% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotGrowthCurves}
\alias{plotGrowthCurves}
\alias{plotlyGrowthCurves}
\title{Plot growth curves}
\usage{
plotGrowthCurves(
  object,
  species = NULL,
  max_age = 20,
  percentage = FALSE,
  species_panel = FALSE,
  highlight = NULL,
  size_at_age = NULL,
  return_data = FALSE,
  ...
)

plotlyGrowthCurves(
  object,
  species = NULL,
  max_age = 20,
  percentage = FALSE,
  species_panel = FALSE,
  highlight = NULL
)
}
\arguments{
\item{object}{MizerSim or MizerParams object. If given a
\linkS4class{MizerSim} object, uses the growth rates at the final time of a
simulation to calculate the size at age. If given a
\linkS4class{MizerParams} object, uses the initial growth rates instead.}

\item{species}{The species to be selected. Optional. By default all target
species are selected. A vector of species names, or a
numeric vector with the species indices, or a logical vector indicating for
each species whether it is to be selected (TRUE) or not.}

\item{max_age}{The age up to which to run the growth curve. Default is 20.}

\item{percentage}{Boolean value. If TRUE, the size is given as a percentage
of the maximal size.}

\item{species_panel}{If TRUE (default), and \code{percentage = FALSE}, display all
species as facets. Otherwise puts all species into a single panel.}

\item{highlight}{Name or vector of names of the species to be highlighted.}

\item{size_at_age}{A data frame with observed size at age data to be plotted
on top of growth curve graphs. Should contain columns \code{species} (species
name as used in the model), \code{age} (in years) and either \code{weight} (in grams)
or \code{length} (in cm). If both \code{weight} and \code{length} are provided, only
\code{weight} is used.}

\item{return_data}{A boolean value that determines whether the formatted data
used for the plot is returned instead of the plot itself. Default value is FALSE}

\item{...}{Other arguments (currently unused)}
}
\value{
A ggplot2 object
}
\description{
The growth curves represent the average age of all the living fish of a
species as a function of their size. So it would be natural to plot size
on the x-axis. But to follow the usual convention from age-based models, we
plot size on the y-axis and age on the x-axis.
}
\details{
When the growth curve for only a single species is plotted, horizontal lines
are included that indicate the maturity size and the maximum size for that
species, as well as a vertical line indicating the maturity age.

If size at age data is passed via the \code{size_at_age} argument, this is plotted
on top of the growth curve. When comparing this to the growth curves, you
need to remember that the growth curves should only represent the average
age at each size. So a scatter in the x-direction around the curve is to be
expected.

For legacy reasons, if the species parameters contain the variables \code{a} and
\code{b} for length to weight conversion and the von Bertalanffy parameter \code{k_vb},
\code{w_inf} (and optionally \code{t0}), then the von Bertalanffy growth curve is
superimposed in black. This was implemented before we understood that the von
Bertalanffy curves (which approximates the average length at each age) should
not be compared to the mizer growth curves (which approximate the average age
at each length).
}
\examples{
\donttest{
params <-  NS_params
sim <- project(params, effort=1, t_max=20, t_save = 2, progress_bar = FALSE)
plotGrowthCurves(sim, percentage = TRUE)
plotGrowthCurves(sim, species = "Cod", max_age = 24)
plotGrowthCurves(sim, species_panel = TRUE)

# Returning the data frame
fr <- plotGrowthCurves(sim, return_data = TRUE)
str(fr)
}
}
\seealso{
\link{plotting_functions}

Other plotting functions: 
\code{\link{animateSpectra}()},
\code{\link{plot,MizerSim,missing-method}},
\code{\link{plotBiomass}()},
\code{\link{plotDiet}()},
\code{\link{plotFMort}()},
\code{\link{plotFeedingLevel}()},
\code{\link{plotPredMort}()},
\code{\link{plotSpectra}()},
\code{\link{plotYieldGear}()},
\code{\link{plotYield}()},
\code{\link{plotting_functions}}
}
\concept{plotting functions}
