% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_helpers.R
\name{gt_fmt_mlb_headshot}
\alias{gt_fmt_mlb_headshot}
\title{Render Player Headshots in 'gt' Tables}
\usage{
gt_fmt_mlb_headshot(
  gt_object,
  columns,
  height = 30,
  na_headshot_to_logo = TRUE
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{columns}{The columns wherein changes to cell data colors should occur.
Has no effect if \code{locations} is not \code{NULL}}

\item{height}{The absolute height (px) of the image in the table cell}

\item{na_headshot_to_logo}{should NA/non matches return the MLB logo instead
of a grayed out blank headshot? Defaults to \code{TRUE}}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
\code{gt_fmt_mlb_headshot} takes an existing \code{gt_tbl} object and converts player ids into headshots.
This is a wrapper around
\href{https://jthomasmock.github.io/gtExtras/reference/gt_img_rows.html}{\code{gtExtras::gt_image_rows()}}
written by Tom Mock, which is a wrapper around \code{gt::text_transform()} + \code{gt::web_image()}/
\code{gt::local_image()} with the necessary boilerplate already applied.
}
\examples{
library(gt)
library(mlbplotR)
gt_headshot_example <- mlbplotR::load_headshots() \%>\%
  head(5) \%>\%
  dplyr::select(player_name, savant_id) \%>\%
  gt::gt() \%>\%
  gt_fmt_mlb_headshot(columns = "savant_id")
}
