% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlim.preimpute.R
\name{mlim.preimpute}
\alias{mlim.preimpute}
\title{carries out preimputation}
\usage{
mlim.preimpute(data, preimpute = "RF", seed = NULL)
}
\arguments{
\item{data}{data.frame with missing values}

\item{preimpute}{character. specify the algorithm for preimputation. the
supported options are "RF" (Random Forest) and "mm"
(mean-mode replacement). the default is "RF", which carries
a parallel random forest imputation, using all the CPUs available.
the other alternative is "mm" which performs mean/mode
imputation.}

\item{seed}{integer. specify the random generator seed}
}
\value{
imputed data.frame
}
\description{
instead of replacing missing data with mean and mode, a smarter
             start-point would be to use fast imputation algorithms and then
             optimize the imputed dataset with mlim. this procedure usually
             requires less iterations and will savea lot of computation
             resources.
}
\examples{
\donttest{
data(iris)

# add 10\% stratified missing values to one factor variable
irisNA <- iris
irisNA$Species <- mlim.na(irisNA$Species, p = 0.1, stratify = TRUE, seed = 2022)

# run the default random forest preimputation
MLIM <- mlim.preimpute(irisNA)
mlim.error(MLIM, irisNA, iris)
}
}
\author{
E. F. Haghish
}
