% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fromeBICtoEstimation.r
\name{fromeBICtoEstimation}
\alias{fromeBICtoEstimation}
\title{Helper function that create the selec_XXclass argument of the Estimation_allmodels function}
\usage{
fromeBICtoEstimation(XX, res.eBIC)
}
\arguments{
\item{XX}{A list of length one, two or three matrices depending on the model. Matrices are n by m matrix, where n=number of individuals, m=number of SNPs, with rownames(X)=individual names, and colnames(X)=SNP names.

- additive: a single matrix

- additive+dominance: two matrices

- female+male: two matrices with the female one first

- female+male+interaction: three matrices with the female first, the male then the interaction}

\item{res.eBIC}{output of the \code{\link{eBIC_allmodels}} function}
}
\description{
Function that create the selec_XXclass argument of the \code{\link{Estimation_allmodels}} function from the output of the \code{\link{eBIC_allmodels}} function.
}
\examples{
### Additive model ###
\dontrun{
data("mlmm.gwas.AD")

XX = list(Xa)
KK = list(K.add)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateAD, XX, KK)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateAD, sel_XX, KK, ncol(Xa))

# Effects estimations with the selected model
sel_XXclass <- fromeBICtoEstimation(XX, res.eBIC)
eff.estimations <- Estimation_allmodels(floweringDateAD, sel_XXclass, KK)
genotypes.boxplot(Xa, floweringDateAD, effects = eff.estimations)
}

### Additive + dominance model
\dontrun{
data("mlmm.gwas.AD")

XX = list(Xa, Xd)
KK = list(K.add, K.dom)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateAD, XX, KK)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateAD, sel_XX, KK, ncol(Xa))
#the selected model is the null model
}


### Female+Male model
\dontrun{
data("mlmm.gwas.FMI")

XX = list(Xf, Xm)
KK = list(K.female, K.male)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateFMI, XX, KK, female = female, male = male)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateFMI, sel_XX, KK, ncol(Xf), female = female, male = male)
#the selected model is the null model
}



### Female+Male+Interaction model
\dontrun{
data("mlmm.gwas.FMI")

XX = list(Xf, Xm, Xfm)
KK = list(K.female, K.male, K.hybrid)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateFMI, XX, KK, female = female, male = male)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateFMI, sel_XX, KK, ncol(Xf), female = female, male = male)
#the selected model is the null model
}
}
\seealso{
\code{\link{eBIC_allmodels}} \code{\link{Estimation_allmodels}}
}
