% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_head_stats.R
\name{get_head_stats}
\alias{get_head_stats}
\title{Calculate Hydraulic Head Statistics}
\usage{
get_head_stats(vars = NULL, by_port = FALSE)
}
\arguments{
\item{vars}{'character' vector.
One or more variable names for which to compute summary statistics.
Choices include:
"total_head_va" is the hydraulic head in feet above the North American Vertical Datum of 1988,
"temp_va" is the fluid temperature in degree Celsius,
"baro_va" is the atmospheric pressure in pounds per square inch absolute (psi), and
"press_va" is the absolute fluid pressure in psi.
By default, all variables are included.}

\item{by_port}{'logical' flag.
Whether to compute statistics according to a sites monitoring port.
Defaults to grouping by site only.}
}
\value{
A data frame with the following variables:
\describe{
\item{\code{var_ds}}{Variable description.}
\item{\code{var_nm}}{Variable name as specified in the \code{vars} argument.}
\item{\code{site_nm}}{Local site name for a MLMS well.}
\item{\code{port_nu}}{Identifier for the valved measurement port,
included only if the \code{by_port} argument is set to true (not the default).}
\item{\code{n}}{Sample size, which is the number of records in a given sample that contain finite values.}
\item{\code{nna}}{Number of missing values that were stripped before the statistic was computed.}
\item{\code{start_dt}}{Start date for the period of record.}
\item{\code{end_dt}}{End date for the period of record.}
\item{\code{duration}}{Duration of the record period, measured in years.}
\item{\code{mean}}{Arithmetic mean of the variable values.}
\item{\code{sd}}{Standard deviation of the variable values.}
\item{\code{min}}{Minimum of the variable values.}
\item{\code{qu_1st}}{First quartile of the variable values.}
\item{\code{median}}{Median of the variable values.}
\item{\code{qu_3rd}}{Third quartile of the variable values.}
\item{\code{max}}{Maximum of the variable values.}
}
}
\description{
Calculate summary statistics for multi-level hydraulic head data,
categorized by site and port, and summarized over time.
}
\examples{
d <- get_head_stats()
str(d)

d <- get_head_stats(vars = "press_va", by_port = TRUE)
str(d)
}
\seealso{
\code{\link{get_head_outliers}} function may be used to identify fluid pressure outliers.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
