% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betweenPlot.R
\name{betweenPlot}
\alias{betweenPlot}
\title{Plots Between Group Associations}
\usage{
betweenPlot(
  x,
  y,
  grouping,
  dataset,
  xlab = x,
  ylab = y,
  between_title = "Between-Group Association Plot",
  point_color = "gray40",
  line_color = "black",
  se = FALSE,
  full_range = FALSE,
  lty = 1,
  size = 2
)
}
\arguments{
\item{x}{Predictor variable.}

\item{y}{Outcome variable.}

\item{grouping}{Grouping variable.}

\item{dataset}{A dataset containing the predictor, outcome, and grouping variables.}

\item{xlab}{Character vector specifying the horizontal axis label.}

\item{ylab}{Character vector specifying the vertical axis label.}

\item{between_title}{Character vector specifying the title for the between group plot.}

\item{point_color}{Color for points.}

\item{line_color}{Color for lines.}

\item{se}{A logical value indicating whether confidence intervals should be displayed.}

\item{full_range}{A logical value indicating whether the fit line should span the full range of the plot or just the data.}

\item{lty}{Line type.}

\item{size}{Width of fit line.}
}
\value{
Produces a plot of the between-group associations between an outcome and predictor variable.
}
\description{
Plots the between-group associations between an outcome and predictor variable.
}
\examples{
# Read in data
data(instruction)
# Produce between plot
betweenPlot(x = "mathkind", y = "mathgain", grouping = "classid",
dataset = instruction, xlab = "Kindergarten Math Score",
ylab = "Gain in Math Score")

}
\references{
Chow, S., Gilmore, R. O., Hallquist, M., Ram, N., & Brinberg, M. (2019). Introduction to multilevel model and interactions. GitHub. https://github.com/psu-psychology/r-bootcamp-2019/blob/master/talks/RBootcamp_MLMInteractions_2019_0820_Final2.Rmd
}
