context("BaggingWrapper")

test_that("BaggingWrapper", {
  lrn1 = makeLearner("classif.rpart")
  lrn2 = makeBaggingWrapper(lrn1, bag.iters=3L)
  m = train(lrn2, multiclass.task)
  expect_true(!inherits(m, "FailureModel"))
  bms = getBaggingModels(m, learner.models=FALSE)
  expect_true(is.list(bms) && length(bms) == lrn2$par.vals$bag.iters)
  expect_true(inherits(bms[[1L]], "WrappedModel"))
  bms = getBaggingModels(m, learner.models=TRUE)
  expect_true(is.list(bms) && length(bms) == lrn2$par.vals$bag.iters)
  expect_true(inherits(bms[[1L]], "rpart"))
  rdesc = makeResampleDesc("CV", iters=2)
  r = resample(lrn2, multiclass.task, rdesc)
  expect_true(r$aggr[[1L]] < 0.15)
  lrn2 = makeBaggingWrapper(lrn1, bag.size = 0.1, bag.replace = FALSE)
  m = train(lrn2, multiclass.task)
  bms = getBaggingModels(m)
  expect_equal(unique(sapply(bms, function(m) length(bms[[1]]$subset))), 15L)
  lrn2 = makeBaggingWrapper(lrn1, bag.iters=3L, bag.feats = 0.5)
  m = train(lrn2, multiclass.task)
  bms = getBaggingModels(m)
  expect_equal(unique(sapply(bms, function(m) length(bms[[1]]$features))), 2L)
  lrn1 = makeLearner("classif.rpart", predict.type="prob")
  lrn2 = makeBaggingWrapper(lrn1, bag.iters=3L)
  m = train(lrn2, binaryclass.task)
  p = predict(m, binaryclass.task)
  getProbabilities(p)
  r = resample(lrn2, binaryclass.task, rdesc, measures=auc)
  
  lrn1 = makeLearner("regr.rpart")
  lrn2 = makeBaggingWrapper(lrn1, bag.iters=3L)
  m = train(lrn2, regr.task)
  p = predict(m, regr.task)
})
