% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotResiduals.R
\name{plotResiduals}
\alias{plotResiduals}
\title{Create residual plots for prediction objects or benchmark results.}
\usage{
plotResiduals(obj, type = "scatterplot", loess.smooth = TRUE, rug = TRUE,
  pretty.names = TRUE)
}
\arguments{
\item{obj}{[\code{\link{Prediction}} | \code{\link{BenchmarkResult}}]\cr
Input data.}

\item{type}{Type of plot. Can be \dQuote{scatterplot}, the default. Or
\dQuote{hist}, for a histogram, or in case of classification problems
a barplot, displaying the residuals.}

\item{loess.smooth}{[\code{logical(1)}]\cr
Should a loess smoother be added to the plot? Defaults to \code{TRUE}.
Only applicable for regression tasks and if \code{type} is set to \code{scatterplot}.}

\item{rug}{[\code{logical(1)}]\cr
Should marginal distributions be added to the plot? Defaults to \code{TRUE}.
Only applicable for regression tasks and if \code{type} is set to \code{scatterplot}.}

\item{pretty.names}{[\code{logical(1)}]\cr
Whether to use the short name of the learner instead of its ID in labels.
Defaults to \code{TRUE}. \cr
Only applicable if a \code{\link{BenchmarkResult}}
is passed to \code{obj} in the function call, ignored otherwise.}
}
\value{
ggplot2 plot object.
}
\description{
Plots for model diagnostics. Provides scatterplots of true vs. predicted values
and histograms of the model's residuals.
}
\seealso{
Other plot: \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialDependenceGGVIS}},
  \code{\link{plotPartialDependence}},
  \code{\link{plotROCCurves}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}
}
