% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterWrapper.R
\name{makeFilterWrapper}
\alias{makeFilterWrapper}
\title{Fuse learner with a feature filter method.}
\usage{
makeFilterWrapper(learner, fw.method = "randomForestSRC.rfsrc",
  fw.perc = NULL, fw.abs = NULL, fw.threshold = NULL,
  fw.mandatory.feat = NULL, ...)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}

\item{fw.method}{(\code{character(1)})\cr
Filter method. See \link{listFilterMethods}.
Default is \dQuote{randomForestSRC.rfsrc}.}

\item{fw.perc}{(\code{numeric(1)})\cr
If set, select \code{fw.perc}*100 top scoring features.
Mutually exclusive with arguments \code{fw.abs} and \code{fw.threshold}.}

\item{fw.abs}{(\code{numeric(1)})\cr
If set, select \code{fw.abs} top scoring features.
Mutually exclusive with arguments \code{fw.perc} and \code{fw.threshold}.}

\item{fw.threshold}{(\code{numeric(1)})\cr
If set, select features whose score exceeds \code{fw.threshold}.
Mutually exclusive with arguments \code{fw.perc} and \code{fw.abs}.}

\item{fw.mandatory.feat}{(\link{character})\cr
Mandatory features which are always included regardless of their scores}

\item{...}{(any)\cr
Additional parameters passed down to the filter.}
}
\value{
\link{Learner}.
}
\description{
Fuses a base learner with a filter method. Creates a learner object, which can be
used like any other learner object.
Internally uses \link{filterFeatures} before every model fit.

After training, the selected features can be retrieved with
\link{getFilteredFeatures}.

Note that observation weights do not influence the filtering and are simply passed
down to the next learner.
}
\examples{
task = makeClassifTask(data = iris, target = "Species")
lrn = makeLearner("classif.lda")
inner = makeResampleDesc("Holdout")
outer = makeResampleDesc("CV", iters = 2)
lrn = makeFilterWrapper(lrn, fw.perc = 0.5)
mod = train(lrn, task)
print(getFilteredFeatures(mod))
# now nested resampling, where we extract the features that the filter method selected
r = resample(lrn, task, outer, extract = function(model) {
  getFilteredFeatures(model)
})
print(r$extract)
}
\seealso{
Other filter: \code{\link{filterFeatures}},
  \code{\link{generateFilterValuesData}},
  \code{\link{getFilterValues}},
  \code{\link{getFilteredFeatures}},
  \code{\link{listFilterMethods}},
  \code{\link{makeFilter}}, \code{\link{plotFilterValues}}

Other wrapper: \code{\link{makeBaggingWrapper}},
  \code{\link{makeClassificationViaRegressionWrapper}},
  \code{\link{makeConstantClassWrapper}},
  \code{\link{makeCostSensClassifWrapper}},
  \code{\link{makeCostSensRegrWrapper}},
  \code{\link{makeDownsampleWrapper}},
  \code{\link{makeDummyFeaturesWrapper}},
  \code{\link{makeExtractFDAFeatsWrapper}},
  \code{\link{makeFeatSelWrapper}},
  \code{\link{makeImputeWrapper}},
  \code{\link{makeMulticlassWrapper}},
  \code{\link{makeMultilabelBinaryRelevanceWrapper}},
  \code{\link{makeMultilabelClassifierChainsWrapper}},
  \code{\link{makeMultilabelDBRWrapper}},
  \code{\link{makeMultilabelNestedStackingWrapper}},
  \code{\link{makeMultilabelStackingWrapper}},
  \code{\link{makeOverBaggingWrapper}},
  \code{\link{makePreprocWrapperCaret}},
  \code{\link{makePreprocWrapper}},
  \code{\link{makeRemoveConstantFeaturesWrapper}},
  \code{\link{makeSMOTEWrapper}},
  \code{\link{makeTuneWrapper}},
  \code{\link{makeUndersampleWrapper}},
  \code{\link{makeWeightedClassesWrapper}}
}
