% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneParamsMultiCrit.R
\name{tuneParamsMultiCrit}
\alias{tuneParamsMultiCrit}
\title{Hyperparameter tuning for multiple measures at once.}
\usage{
tuneParamsMultiCrit(learner, task, resampling, measures, par.set, control,
  show.info = getMlrOption("show.info"), resample.fun = resample)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}

\item{task}{(\link{Task})\cr
The task.}

\item{resampling}{([ResampleInstance] | [ResampleDesc])\cr
Resampling strategy to evaluate points in hyperparameter space. If you pass a description,
it is instantiated once at the beginning by default, so all points are
evaluated on the same training/test sets.
If you want to change that behavior, look at [TuneMultiCritControl].}

\item{measures}{[list of [Measure])\cr
Performance measures to optimize simultaneously.}

\item{par.set}{([ParamHelpers::ParamSet])\cr
Collection of parameters and their constraints for optimization.
Dependent parameters with a `requires` field must use `quote` and not
`expression` to define it.}

\item{control}{([TuneMultiCritControl])\cr
Control object for search method. Also selects the optimization algorithm for tuning.}

\item{show.info}{(\code{logical(1)})\cr
Print verbose output on console?
Default is set via \link{configureMlr}.}

\item{resample.fun}{([closure`)\cr
The function to use for resampling. Defaults to [resample] and should take the
same arguments as, and return the same result type as, [resample].}
}
\value{
([TuneMultiCritResult]).
}
\description{
Optimizes the hyperparameters of a learner in a multi-criteria fashion.
Allows for different optimization methods, such as grid search, evolutionary strategies, etc.
You can select such an algorithm (and its settings)
by passing a corresponding control object. For a complete list of implemented algorithms look at
[TuneMultiCritControl].
}
\examples{
\donttest{
# multi-criteria optimization of (tpr, fpr) with NGSA-II
lrn =  makeLearner("classif.ksvm")
rdesc = makeResampleDesc("Holdout")
ps = makeParamSet(
  makeNumericParam("C", lower = -12, upper = 12, trafo = function(x) 2^x),
  makeNumericParam("sigma", lower = -12, upper = 12, trafo = function(x) 2^x)
)
ctrl = makeTuneMultiCritControlNSGA2(popsize = 4L, generations = 1L)
res = tuneParamsMultiCrit(lrn, sonar.task, rdesc, par.set = ps,
  measures = list(tpr, fpr), control = ctrl)
plotTuneMultiCritResult(res, path = TRUE)
}
}
\seealso{
Other tune_multicrit: \code{\link{TuneMultiCritControl}},
  \code{\link{plotTuneMultiCritResult}}
}
