% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultilabelBinaryRelevanceWrapper.R
\name{makeMultilabelBinaryRelevanceWrapper}
\alias{makeMultilabelBinaryRelevanceWrapper}
\title{Use binary relevance method to create a multilabel learner.}
\usage{
makeMultilabelBinaryRelevanceWrapper(learner)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}
}
\value{
\link{Learner}.
}
\description{
Every learner which is implemented in mlr and which supports binary
classification can be converted to a wrapped binary relevance multilabel learner.
The multilabel classification problem is converted into simple binary classifications
for each label/target on which the binary learner is applied.

Models can easily be accessed via \link{getLearnerModel}.

Note that it does not make sense to set a threshold in the used base \code{learner}
when you predict probabilities.
On the other hand, it can make a lot of sense, to call \link{setThreshold}
on the \code{MultilabelBinaryRelevanceWrapper} for each label indvidually;
Or to tune these thresholds with \link{tuneThreshold}; especially when you face very
unabalanced class distributions for each binary label.
}
\examples{
d = getTaskData(yeast.task)
# drop some labels so example runs faster
d = d[seq(1, nrow(d), by = 20), c(1:2, 15:17)]
task = makeMultilabelTask(data = d, target = c("label1", "label2"))
lrn = makeLearner("classif.rpart")
lrn = makeMultilabelBinaryRelevanceWrapper(lrn)
lrn = setPredictType(lrn, "prob")
# train, predict and evaluate
mod = train(lrn, task)
pred = predict(mod, task)
performance(pred, measure = list(multilabel.hamloss, multilabel.subset01, multilabel.f1))
# the next call basically has the same structure for any multilabel meta wrapper
getMultilabelBinaryPerformances(pred, measures = list(mmce, auc))
# above works also with predictions from resample!

}
\references{
Tsoumakas, G., & Katakis, I. (2006)
\emph{Multi-label classification: An overview.}
Dept. of Informatics, Aristotle University of Thessaloniki, Greece.
}
\seealso{
Other wrapper: \code{\link{makeBaggingWrapper}},
  \code{\link{makeClassificationViaRegressionWrapper}},
  \code{\link{makeConstantClassWrapper}},
  \code{\link{makeCostSensClassifWrapper}},
  \code{\link{makeCostSensRegrWrapper}},
  \code{\link{makeDownsampleWrapper}},
  \code{\link{makeDummyFeaturesWrapper}},
  \code{\link{makeExtractFDAFeatsWrapper}},
  \code{\link{makeFeatSelWrapper}},
  \code{\link{makeFilterWrapper}},
  \code{\link{makeImputeWrapper}},
  \code{\link{makeMulticlassWrapper}},
  \code{\link{makeMultilabelClassifierChainsWrapper}},
  \code{\link{makeMultilabelDBRWrapper}},
  \code{\link{makeMultilabelNestedStackingWrapper}},
  \code{\link{makeMultilabelStackingWrapper}},
  \code{\link{makeOverBaggingWrapper}},
  \code{\link{makePreprocWrapperCaret}},
  \code{\link{makePreprocWrapper}},
  \code{\link{makeRemoveConstantFeaturesWrapper}},
  \code{\link{makeSMOTEWrapper}},
  \code{\link{makeTuneWrapper}},
  \code{\link{makeUndersampleWrapper}},
  \code{\link{makeWeightedClassesWrapper}}

Other multilabel: \code{\link{getMultilabelBinaryPerformances}},
  \code{\link{makeMultilabelClassifierChainsWrapper}},
  \code{\link{makeMultilabelDBRWrapper}},
  \code{\link{makeMultilabelNestedStackingWrapper}},
  \code{\link{makeMultilabelStackingWrapper}}
}
