% Generated by roxygen2 (4.0.2): do not edit by hand
\name{oversample}
\alias{oversample}
\alias{undersample}
\title{Over- or undersample binary classification task to handle class imbalancy.}
\usage{
oversample(task, rate)

undersample(task, rate)
}
\arguments{
\item{task}{[\code{\link{Task}}]\cr
The task.}

\item{rate}{[\code{numeric(1)}]\cr
Factor to upsample the smaller or downsample the bigger class.
For undersampling: Must be between 0 and 1,
where 1 means no downsampling, 0.5 implies reduction to 50 percent
and 0 would imply reduction to 0 observations.
For oversampling: Must be between 1 and \code{Inf},
where 1 means no oversampling and 2 would mean doubling the class size.}
}
\value{
[\code{\link{Task}}].
}
\description{
Oversampling: From the smaller class, observations are randomly drawn with repetitions.

Undersampling: From the larger class, observations are randomly drawn without repetitions.
}
\seealso{
Other imbalancy: \code{\link{makeOverBaggingWrapper}};
  \code{\link{makeOversampleWrapper}},
  \code{\link{makeUndersampleWrapper}}; \code{\link{smote}}
}

