#' @export
makeRLearner.regr.btlm = function() {
  makeRLearnerRegr(
    cl = "regr.btlm",
    package = "tgp",
    par.set = makeParamSet(
      makeDiscreteLearnerParam(id = "meanfn", default = "linear", 
        values = c("constant", "linear")), 
      makeDiscreteLearnerParam(id = "bprior", default = "bflat", 
        values = c("b0", "b0not", "bflat", "bmle", "bmznot", "bmzt")),
      makeNumericVectorLearnerParam(id = "tree", len = 2, default = c(0.5, 2), 
        lower = c(0, 0), upper = c(1, Inf)),
      makeIntegerVectorLearnerParam(id = "BTE", len = 3, 
        default = c(2000, 7000, 2), lower = 0), 
      makeIntegerLearnerParam(id = "R", default = 1, lower = 1), 
      makeLogicalLearnerParam(id = "m0r1", default = TRUE),
      makeUntypedLearnerParam(id = "itemps", default = NULL)
    ),
    properties = c("numerics", "se", "factors"),
    name = "Bayesian Treed Linear Model",
    short.name = "btlm"
  )
}

#' @export
trainLearner.regr.btlm = function(.learner, .task, .subset, .weights = NULL, ...) {
  d = getTaskData(.task, .subset, target.extra = TRUE)
  # factor variables must be in the last columns as dummy variables:
  col.types = vcapply(d$data, function(x) class(x))
  factor.ind = (col.types == "factor")
  if (any(factor.ind)) {
    d.num = d$data[, !factor.ind, drop = FALSE]
    n.num = ncol(d.num)
    d.factor = d$data[, factor.ind, drop = FALSE]
    d.factor = createDummyFeatures(d.factor, method = "reference")
    d$data = cbind(d.num, d.factor)
    print(names(d$data))
    return(tgp::btlm(X = d$data, Z = d$target, basemax = n.num, pred.n = FALSE, ...))
  } else {
    return(tgp::btlm(X = d$data, Z = d$target, pred.n = FALSE, ...))
  }
}

#' @export
predictLearner.regr.btlm = function(.learner, .model, .newdata, ...) {
  # factor variables must be in the last columns as dummy variables:
  col.types = vcapply(.newdata, function(x) class(x))
  factor.ind = (col.types == "factor")
  if (any(factor.ind)) {
    newdata.num = .newdata[, !factor.ind, drop = FALSE]
    newdata.factor = .newdata[, factor.ind, drop = FALSE]
    newdata.factor = createDummyFeatures(newdata.factor, method = "reference")
    newdata = cbind(newdata.num, newdata.factor)
    print(names(newdata))
    p = predict(.model$learner.model, XX = newdata, pred.n = FALSE, ...)
  } else {
    p = predict(.model$learner.model, XX = .newdata, pred.n = FALSE, ...)
  }
  if (.learner$predict.type == "response") {
    return(p$ZZ.km)
  } else {
    return(cbind(p$ZZ.km, sqrt(p$ZZ.ks2)))
  }
}  
