% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/setThreshold.R
\name{setThreshold}
\alias{setThreshold}
\title{Set threshold of prediction object.}
\usage{
setThreshold(pred, threshold)
}
\arguments{
\item{pred}{[\code{\link{Prediction}}]\cr
Prediction object.}

\item{threshold}{[\code{numeric}]\cr
Threshold to produce class labels. Has to be a named vector, where names correspond to class labels.
Only for binary classification it can be a single numerical threshold for the positive class.}
}
\value{
[\code{\link{Prediction}}] with changed threshold and corresponding response.
}
\description{
Set threshold of prediction object for classification.
Creates corresponding discrete class response for the newly set threshold.
For binary classification: The positive class is predicted if the probability value exceeds the threshold.
For multiclass: Probabilities are divided by corresponding thresholds and the class with maximum resulting value is selected.
The result of both are equivalent if in the multi-threshold case the values are greater than 0 and sum to 1.
}
\examples{
## create task and train learner (LDA)
task = makeClassifTask(data = iris, target = "Species")
lrn = makeLearner("classif.lda", predict.type = "prob")
mod = train(lrn, task)

## predict probabilities and compute performance
pred = predict(mod, newdata = iris)
performance(pred, measures = mmce)
head(as.data.frame(pred))
## adjust threshold and predict probabilities again
threshold = c(setosa = 0.4, versicolor = 0.3, virginica = 0.3)
pred = setThreshold(pred, threshold = threshold)
performance(pred, measures = mmce)
head(as.data.frame(pred))
}
\seealso{
\code{\link{predict.WrappedModel}}
}

