% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Task_operators.R
\name{getTaskData}
\alias{getTaskData}
\title{Extract data in task.}
\usage{
getTaskData(task, subset, features, target.extra = FALSE,
  recode.target = "no")
}
\arguments{
\item{task}{[\code{\link{Task}}]\cr
The task.}

\item{subset}{[\code{integer}]\cr
Selected cases.
Default is all cases.}

\item{features}{[\code{character}]\cr
Selected features.
Default is all.}

\item{target.extra}{[\code{logical(1)}]\cr
Should target vector be returned separately?
If not, a single data.frame including the target columns is returned, otherwise a list
with the input data.frame and an extra vector or data.frame for the targets.
Default is \code{FALSE}.}

\item{recode.target}{[\code{character(1)}]\cr
Should target classes be recoded? Supported are binary classification and survival.
Possible values for binary classification are \dQuote{01}, \dQuote{-1+1} and \dQuote{drop.levels}.
In the two latter cases the target vector is converted into a numeric vector.
The positive class is coded as \dQuote{+1} and the negative class either as \dQuote{0} or \dQuote{-1}.
\dQuote{drop.levels} will remove empty factor levels in the target column.
For survival, you may choose to recode the survival times to \dQuote{left}, \dQuote{right} or \dQuote{interval2} censored times
using \dQuote{lcens}, \dQuote{rcens} or \dQuote{icens}, respectively.
See \code{\link[survival]{Surv}} for the format specification.
Default for both binary classification and survival is \dQuote{no} (do nothing).}
}
\value{
Either a data.frame or a list with data.frame \code{data} and vector \code{target}.
}
\description{
Useful in \code{\link{trainLearner}} when you add a learning machine to the package.
}
\examples{
library("mlbench")
data(BreastCancer)

df = BreastCancer
df$Id = NULL
task = makeClassifTask(id = "BreastCancer", data = df, target = "Class", positive = "malignant")
head(getTaskData)
head(getTaskData(task, features = c("Cell.size", "Cell.shape"), recode.target = "-1+1"))
head(getTaskData(task, subset = 1:100, recode.target = "01"))
}
\seealso{
Other task: \code{\link{getTaskClassLevels}},
  \code{\link{getTaskCosts}},
  \code{\link{getTaskDescription}},
  \code{\link{getTaskFeatureNames}},
  \code{\link{getTaskFormula}}, \code{\link{getTaskId}},
  \code{\link{getTaskNFeats}}, \code{\link{getTaskSize}},
  \code{\link{getTaskTargetNames}},
  \code{\link{getTaskTargets}}, \code{\link{getTaskType}},
  \code{\link{subsetTask}}
}

