% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{mlr_assertions}
\alias{mlr_assertions}
\alias{assert_backend}
\alias{assert_task}
\alias{assert_tasks}
\alias{assert_learner}
\alias{assert_learners}
\alias{assert_measure}
\alias{assert_measures}
\alias{assert_resampling}
\alias{assert_resamplings}
\alias{assert_prediction}
\alias{assert_resample_result}
\alias{assert_benchmark_result}
\alias{assert_row_ids}
\title{Assertion for mlr3 Objects}
\usage{
assert_backend(b, .var.name = vname(b))

assert_task(task, task_type = NULL, feature_types = NULL,
  task_properties = NULL, clone = FALSE, min_rows = 1,
  min_cols = 1)

assert_tasks(tasks, feature_types = NULL, task_properties = NULL,
  clone = FALSE)

assert_learner(learner, task = NULL, properties = character(0L),
  clone = FALSE)

assert_learners(learners, task = NULL, properties = character(0L),
  clone = FALSE)

assert_measure(measure, task_type = NULL, task = NULL,
  learner = NULL, clone = FALSE)

assert_measures(measures, task_type = NULL, task = NULL,
  learner = NULL, clone = FALSE)

assert_resampling(resampling, instantiated = NULL, clone = FALSE)

assert_resamplings(resamplings, instantiated = NULL, clone = FALSE)

assert_prediction(prediction)

assert_resample_result(resample_result,
  .var.name = vname(resample_result))

assert_benchmark_result(bmr, .var.name = vname(bmr))

assert_row_ids(row_ids, type = NULL, .var.name = vname(row_ids))
}
\arguments{
\item{b}{:: \link{DataBackend}.}

\item{task}{:: \link{Task}.}

\item{task_type}{:: \code{character(1)}\cr
Task type, e.g. \code{"classif"} or \code{"regr"}.}

\item{feature_types}{:: \code{character()}\cr
Set of allowed feature types.}

\item{task_properties}{:: \code{character()}\cr
Set of required task properties.}

\item{min_rows}{:: \code{integer()}\cr
Minimum amount of required observations.}

\item{min_cols}{:: \code{integer()}\cr
Minimum amount of required features.}

\item{tasks}{:: list of \link{Task}.}

\item{learner}{:: \link{Learner}.}

\item{learners}{:: list of \link{Learner}.}

\item{measure}{:: \link{Measure}.}

\item{measures}{:: list of \link{Measure}.}

\item{resampling}{:: \link{Resampling}.}

\item{resamplings}{:: list of \link{Resampling}.}

\item{prediction}{:: \link{Prediction}.}

\item{resample_result}{:: \link{ResampleResult}.}

\item{bmr}{:: \link{BenchmarkResult}.}

\item{row_ids}{:: \code{vector()}.}
}
\description{
Functions intended to be used in packages extending \pkg{mlr3}.
}
\keyword{internal}
