% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample}
\alias{resample}
\title{Resample a Learner on a Task}
\usage{
resample(task, learner, resampling, ctrl = list())
}
\arguments{
\item{task}{:: \link{Task}.}

\item{learner}{:: \link{Learner}.}

\item{resampling}{:: \link{Resampling}.}

\item{ctrl}{:: named \code{list()}\cr
Object to control learner execution. See \code{\link[=mlr_control]{mlr_control()}} for details.}
}
\value{
\link{ResampleResult}.
}
\description{
Runs a resampling (possibly in parallel).
}
\note{
The fitted models are discarded after the predictions have been scored in order to reduce memory consumption.
If you need access to the models for later analysis, set \code{store_models} to \code{TRUE} via \code{\link[=mlr_control]{mlr_control()}}.
}
\section{Syntactic Sugar}{


The mlr3 package provides some shortcuts to ease the creation of its objects.

First, instead of an object, it is possible to pass a string identifier which is used to lookup the object in a \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}:
\itemize{
\item \link{Task} in \link{mlr_tasks}.
\item \link{Learner} in \link{mlr_learners}.
\item \link{Resampling} in \link{mlr_resamplings}.
\item \link{Measure} in \link{mlr_measures}.
}

Additionally, each task type has an associated default measure (stored in \link{mlr_reflections}) which is used as a fallback if no other measure is provided.
Classification tasks default to the classification error in \link[=mlr_measures_classif.ce]{"classif.ce"}, regression tasks to the mean squared error in \link[=mlr_measures_regr.mse]{"regr.mse"}.
}

\section{Parallelization}{


This function can be parallelized with the \CRANpkg{future} package.
One job is one resampling iteration, and all jobs are send to an apply function
from \CRANpkg{future.apply} in a single batch.
To select a parallel backend, use \code{\link[future:plan]{future::plan()}}.
}

\examples{
task = mlr_tasks$get("iris")
learner = mlr_learners$get("classif.rpart")
resampling = mlr_resamplings$get("cv")

# explicitly instantiate the resampling for this task for reproduciblity
set.seed(123)
resampling$instantiate(task)

rr = resample(task, learner, resampling)
print(rr)

# retrieve performance
rr$performance("classif.ce")
rr$aggregate("classif.ce")

# merged prediction objects of all resampling iterations
pred = rr$prediction
pred$confusion

# Repeat resampling with featureless learner
rr.featureless = resample(task, "classif.featureless", resampling)

# Combine the ResampleResults into a BenchmarkResult
bmr = rr$combine(rr.featureless)
print(bmr)
}
