% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_metrics.R
\name{compare_metrics}
\alias{compare_metrics}
\title{Compare different metrics}
\usage{
compare_metrics(object, ...)
}
\arguments{
\item{object}{(\link{PredictionClassif} | \link{BenchmarkResult} | \link{ResampleResult})\cr
The object to create a plot for.
\itemize{
\item If provided a (\link{PredictionClassif}).
Then the visualization will compare the fairness metrics among the binary level from protected field
through bar plots.
\item If provided a (\link{ResampleResult}).
Then the visualization will generate the boxplots for fairness metrics, and compare them among
the binary level from protected field.
\item If provided a (\link{BenchmarkResult}).
Then the visualization will generate the boxplots for fairness metrics, and compare them among
both the binary level from protected field and the models implemented.
}}

\item{...}{The arguments to be passed to methods, such as:
\itemize{
\item \code{fairness_measures} (list of \link{Measure})\cr
The fairness measures that will evaluated on object, could be single \link{Measure} or list of \link{Measure}s.
Default measure set to be \code{msr("fairness.acc")}.
\item \code{task} (\link{TaskClassif})\cr
The data task that contains the protected column, only required when object is (\link{PredictionClassif}).
}}
}
\value{
A 'ggplo2' object.
}
\description{
Compare learners with respect to to one or multiple metrics.
Metrics can but be but are not limited to fairness metrics.
}
\examples{
library(mlr3learners)

# Setup the Fairness Measures and tasks
task = tsk("adult_train")$filter(1:500)
learner = lrn("classif.ranger", predict_type = "prob")
learner$train(task)
predictions = learner$predict(task)
design = benchmark_grid(
  tasks = task,
  learners = lrns(c("classif.ranger", "classif.rpart"),
    predict_type = "prob", predict_sets = c("train", "predict")),
  resamplings = rsmps("cv", folds = 3)
)

bmr = benchmark(design)
fairness_measure = msr("fairness.tpr")
fairness_measures = msrs(c("fairness.tpr", "fairness.fnr", "fairness.acc"))

# Predictions
compare_metrics(predictions, fairness_measure, task)
compare_metrics(predictions, fairness_measures, task)

# BenchmarkResult and ResamplingResult
compare_metrics(bmr, fairness_measure)
compare_metrics(bmr, fairness_measures)
}
