% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelector.R
\name{FSelector}
\alias{FSelector}
\title{FSelector}
\description{
Abstract \code{FSelector} class that implements the base functionality each
fselector must provide. A \code{FSelector} object describes the feature selection
strategy, i.e. how to optimize the black-box function and its feasible set
defined by the \link{FSelectInstanceSingleCrit} / \link{FSelectInstanceMultiCrit} object.

A fselector must write its result into the \link{FSelectInstanceSingleCrit} /
\link{FSelectInstanceMultiCrit} using the \code{assign_result} method of the
\link[bbotk:OptimInstance]{bbotk::OptimInstance} at the end of its selection in order to store the best
selected feature subset and its estimated performance vector.
}
\section{Private Methods}{

\itemize{
\item \code{.optimize(instance)} -> \code{NULL}\cr
Abstract base method. Implement to specify feature selection of your
subclass. See technical details sections.
\item \code{.assign_result(instance)} -> \code{NULL}\cr
Abstract base method. Implement to specify how the final feature subset is
selected. See technical details sections.
}
}

\section{Technical Details and Subclasses}{

A subclass is implemented in the following way:
\itemize{
\item Inherit from \code{FSelector}.
\item Specify the private abstract method \verb{$.optimize()} and use it to call into
your optimizer.
\item You need to call \code{instance$eval_batch()} to evaluate feature subsets.
\item The batch evaluation is requested at the \link{FSelectInstanceSingleCrit} /
\link{FSelectInstanceMultiCrit} object \code{instance}, so each batch is possibly
executed in parallel via \code{\link[mlr3:benchmark]{mlr3::benchmark()}}, and all evaluations are stored
inside of \code{instance$archive}.
\item Before the batch evaluation, the \link[bbotk:Terminator]{bbotk::Terminator} is checked, and if it is
positive, an exception of class \code{"terminated_error"} is generated. In the
later case the current batch of evaluations is still stored in \code{instance},
but the numeric scores are not sent back to the handling optimizer as it has
lost execution control.
\item After such an exception was caught we select the best feature subset from
\code{instance$archive} and return it.
\item Note that therefore more points than specified by the \link[bbotk:Terminator]{bbotk::Terminator}
may be evaluated, as the Terminator is only checked before a batch
evaluation, and not in-between evaluation in a batch. How many more depends
on the setting of the batch size.
\item Overwrite the private super-method \code{.assign_result()} if you want to decide
yourself how to estimate the final feature subset in the instance and its
estimated performance. The default behavior is: We pick the best
resample-experiment, regarding the given measure, then assign its
feature subset and aggregated performance to the instance.
}
}

\examples{
library(mlr3)

terminator = trm("evals", n_evals = 3)

instance = FSelectInstanceSingleCrit$new(
  task = tsk("iris"),
  learner = lrn("classif.rpart"),
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  terminator = terminator
)

# swap this line to use a different FSelector
fselector = fs("random_search")
\donttest{
# modifies the instance by reference
fselector$optimize(instance)

# returns best feature subset and best performance
instance$result

# allows access of data.table / benchmark result of full path of all evaluations
instance$archive}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet}).}

\item{\code{param_classes}}{(\code{character()}).}

\item{\code{properties}}{(\code{character()}).}

\item{\code{packages}}{(\code{character()}).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FSelector$new()}}
\item \href{#method-format}{\code{FSelector$format()}}
\item \href{#method-print}{\code{FSelector$print()}}
\item \href{#method-optimize}{\code{FSelector$optimize()}}
\item \href{#method-clone}{\code{FSelector$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelector$new(param_set, properties, packages = character(0))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{\link[paradox:ParamSet]{paradox::ParamSet}\cr
Set of control parameters for fselector.}

\item{\code{properties}}{(\code{character()})\cr
Set of properties of the fselector. Must be a subset of
\code{\link[mlr3:mlr_reflections]{mlr_reflections$fselect_properties}}.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages. Note that these packages will be loaded via
\code{\link[=requireNamespace]{requireNamespace()}}, and are not attached.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelector$format()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character()}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelector$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character()}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-optimize}{}}}
\subsection{Method \code{optimize()}}{
Performs the feature selection on a \link{FSelectInstanceSingleCrit} or
\link{FSelectInstanceMultiCrit} until termination.
The single evaluations will be written into the \link{ArchiveFSelect} that resides in the
\link{FSelectInstanceSingleCrit} / \link{FSelectInstanceMultiCrit}.
The result will be written into the instance object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelector$optimize(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{FSelectInstanceSingleCrit}|\link{FSelectInstanceMultiCrit}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[data.table:data.table]{data.table::data.table}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
