#' @importFrom utils bibentry
bibentries = c(
  bossek_2017 = bibentry("inproceedings",
    doi         = "10.1145/3067695.3082470",
    year        = "2017",
    month       = "jul",
    publisher   = "ACM",
    author      = "Jakob Bossek",
    title       = "ecr 2.0",
    booktitle   = "Proceedings of the Genetic and Evolutionary Computation Conference Companion"
  ),

  bergstra_2012 = bibentry("article",
    title       = "Random Search for Hyper-Parameter Optimization",
    author      = "James Bergstra and Yoshua Bengio",
    year        = "2012",
    journal     = "Journal of Machine Learning Research",
    volume      = "13",
    number      = "10",
    pages       = "281--305",
    url         = "https://jmlr.csail.mit.edu/papers/v13/bergstra12a.html"
  ),

  thomas2017  = bibentry("article",
    doi       = "10.1155/2017/1421409",
    year      = "2017",
    publisher = "Hindawi Limited",
    volume    = "2017",
    pages     = "1--8",
    author    = "Janek Thomas and Tobias Hepp and Andreas Mayr and Bernd Bischl",
    title     = "Probing for Sparse and Fast Variable Selection with Model-Based Boosting",
    journal   = "Computational and Mathematical Methods in Medicine"
  ),

  wu2007      = bibentry("article",
    doi       = "10.1198/016214506000000843",
    year      = "2007",
    month     = "3",
    publisher = "Informa {UK} Limited",
    volume    = "102",
    number    = "477",
    pages     = "235--243",
    author    = "Yujun Wu and Dennis D Boos and Leonard A Stefanski",
    title     = "Controlling Variable Selection by the Addition of Pseudovariables",
    journal   = "Journal of the American Statistical Association"
  ),

  guyon2002     = bibentry("article",
    title       = "Gene Selection for Cancer Classification using Support Vector Machines",
    volume      = "46",
    issn        = "1573-0565",
    doi         = "10.1023/A:1012487302797",
    pages       = "389--422",
    number      = "1",
    journal     = "Machine Learning",
    author      = "Isabelle Guyon and Jason Weston and Stephen Barnhill and Vladimir Vapnik",
    year        = "2002"
  ),

  kuhn2013 = bibentry("Inbook",
    author    = "Kuhn, Max and Johnson, Kjell",
    chapter   = "Over-Fitting and Model Tuning",
    title     = "Applied Predictive Modeling",
    year      = "2013",
    publisher = "Springer New York",
    address   = "New York, NY",
    pages     = "61--92",
    isbn      = "978-1-4614-6849-3"
  ),

  saeys2008 = bibentry("article",
    author      = "Saeys, Yvan and Abeel, Thomas and Van De Peer, Yves",
    doi         = "10.1007/978-3-540-87481-2_21",
    isbn        = "3540874801",
    journal     = "Machine Learning and Knowledge Discovery in Databases",
    pages       = "313--325",
    publisher   = "Springer, Berlin, Heidelberg",
    title       = "Robust feature selection using ensemble feature selection techniques",
    volume      = "5212 LNAI",
    year        = "2008"
  ),

  abeel2010 = bibentry("article",
    author    = "Abeel, Thomas and Helleputte, Thibault and Van de Peer, Yves and Dupont, Pierre and Saeys, Yvan",
    doi       = "10.1093/BIOINFORMATICS/BTP630",
    issn      = "1367-4803",
    journal   = "Bioinformatics",
    month     = "feb",
    pages     = "392--398",
    publisher = "Oxford Academic",
    title     = "Robust biomarker identification for cancer diagnosis with ensemble feature selection methods",
    volume    = "26",
    year      = "2010"
  ),

  pes2020 = bibentry("article",
    author    = "Pes, Barbara",
    doi       = "10.1007/s00521-019-04082-3",
    issn      = "14333058",
    journal   = "Neural Computing and Applications",
    month     = "may",
    number    = "10",
    pages     = "5951--5973",
    publisher = "Springer",
    title     = "Ensemble feature selection for high-dimensional data: a stability analysis across multiple domains",
    volume    = "32",
    year      = "2020"
  ),

  das1999 = bibentry("article",
    author    = "Das, I",
    issn      = "09344373",
    journal   = "Structural Optimization",
    month     = "may",
    number    = "1-2",
    pages     = "107--115",
    publisher = "Springer",
    title     = "On characterizing the 'knee' of the Pareto curve based on normal-boundary intersection",
    volume    = "18",
    year      = "1999"
  )
)
