% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regr_ktau.R
\name{ktau}
\alias{ktau}
\title{Kendall's tau}
\usage{
ktau(truth, response, ...)
}
\arguments{
\item{truth}{:: \code{numeric()}\cr
True (observed) values.
Must have the same length as \code{response}.}

\item{response}{:: \code{numeric()}\cr
Predicted response values.
Must have the same length as \code{truth}.}

\item{...}{:: \code{any}\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Regression measure defined as Kendall's rank correlation coefficient between truth and response.
Calls \code{\link[stats:cor]{stats::cor()}} with \code{method} set to \code{"kendall"}.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"regr"}
\item Range: \eqn{[-1, 1]}{[-1, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
truth = 1:10
response = truth + rnorm(10)
ktau(truth, response)
}
\references{
\cite{rosset_2006}
}
\seealso{
Other Regression Measures: \code{\link{bias}},
  \code{\link{mae}}, \code{\link{mape}},
  \code{\link{maxae}}, \code{\link{maxse}},
  \code{\link{medae}}, \code{\link{medse}},
  \code{\link{mse}}, \code{\link{msle}},
  \code{\link{pbias}}, \code{\link{rae}},
  \code{\link{rmse}}, \code{\link{rmsle}},
  \code{\link{rrse}}, \code{\link{rse}}, \code{\link{rsq}},
  \code{\link{sae}}, \code{\link{smape}},
  \code{\link{srho}}, \code{\link{sse}}
}
\concept{Regression Measures}
\concept{regression_measure}
