% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regr_mse.R
\name{mse}
\alias{mse}
\title{Mean Squared Error}
\usage{
mse(truth, response, sample_weights = NULL, ...)
}
\arguments{
\item{truth}{(\code{numeric()})\cr
True (observed) values.
Must have the same length as \code{response}.}

\item{response}{(\code{numeric()})\cr
Predicted response values.
Must have the same length as \code{truth}.}

\item{sample_weights}{(\code{numeric()})\cr
Vector of non-negative and finite sample weights.
Must have the same length as \code{truth}.
The vector gets automatically normalized to sum to one.
Defaults to equal sample weights.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare true observed response with predicted response in regression tasks.
}
\details{
The Mean Squared Error is defined as \deqn{
  \frac{1}{n} w_i \sum_{i=1}^n \left( t_i - r_i \right)^2.
}{
  weighted.mean((t - r)^2, w).
}
}
\section{Meta Information}{

\itemize{
\item Type: \code{"regr"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
truth = 1:10
response = truth + rnorm(10)
mse(truth, response)
}
\seealso{
Other Regression Measures: 
\code{\link{ae}()},
\code{\link{ape}()},
\code{\link{bias}()},
\code{\link{ktau}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{maxae}()},
\code{\link{maxse}()},
\code{\link{medae}()},
\code{\link{medse}()},
\code{\link{msle}()},
\code{\link{pbias}()},
\code{\link{rae}()},
\code{\link{rmse}()},
\code{\link{rmsle}()},
\code{\link{rrse}()},
\code{\link{rse}()},
\code{\link{rsq}()},
\code{\link{sae}()},
\code{\link{se}()},
\code{\link{sle}()},
\code{\link{smape}()},
\code{\link{srho}()},
\code{\link{sse}()}
}
\concept{Regression Measures}
\concept{regression_measure}
