% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvGlmnet.R
\name{LearnerSurvGlmnet}
\alias{LearnerSurvGlmnet}
\alias{mlr_learners_surv.glmnet}
\title{GLM with Elastic Net Regularization Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[glmnet:glmnet]{glmnet::glmnet()}}.
\itemize{
\item lp is predicted by \code{\link[glmnet:predict.glmnet]{glmnet::predict.glmnet()}}
\item \code{crank} is identical to \code{lp}
}

Use \link{LearnerSurvGlmnet} and \link{LearnerSurvCVGlmnet} for glmnets without and with internal
cross-validation, respectively. Tuning using the internal optimizer in \link{LearnerSurvCVGlmnet}
may be more efficient when tuning lambda only. However, for tuning multiple hyperparameters,
\CRANpkg{mlr3tuning} and \link{LearnerSurvGlmnet} will likely give better results.

Parameter \code{s} (value of the regularization parameter used for predictions) is set to the median
of the \code{lambda} sequence by default, but needs to be tuned by the user.
}
\section{Construction}{
\preformatted{LearnerSurvGlmnet$new()
mlr_learners$get("surv.glmnet")
lrn("surv.glmnet")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{crank, lp}
\item Feature Types: \verb{integer, numeric, factor}
\item Packages: \CRANpkg{glmnet} \CRANpkg{survival}
}
}

\references{
\cite{mlr3proba}{friedman_2010}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
