% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvRpart.R
\name{LearnerSurvRpart}
\alias{LearnerSurvRpart}
\alias{mlr_learners_surv.rpart}
\title{Rpart Survival Forest Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[rpart:rpart]{rpart::rpart()}}.
\itemize{
\item distr is predicted using \code{\link[pec:pecRpart]{pec::pecRpart()}} and \code{\link[pec:predictSurvProb]{pec::predictSurvProb()}}
\item \code{crank} is predicted as the expectation of the survival distribution, \code{distr}
}

Parameter \code{xval} is set to 0 in order to save some computation time.
}
\section{Construction}{
\preformatted{LearnerSurvRpart$new()
mlr_learners$get("surv.rpart")
lrn("surv.rpart")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{crank, distr}
\item Feature Types: \verb{logical, integer, numeric, character, factor, ordered}
\item Packages: \CRANpkg{rpart} \CRANpkg{distr6} \CRANpkg{survival}
}
}

\references{
\cite{mlr3proba}{breiman_1984}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
