% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelines.R
\name{mlr_graphs_survaverager}
\alias{mlr_graphs_survaverager}
\alias{pipeline_survaverager}
\title{Survival Prediction Averaging Pipeline}
\usage{
pipeline_survaverager(learners, param_vals = list(), graph_learner = FALSE)
}
\arguments{
\item{learners}{\code{(list())} \cr
List of \link{LearnerSurv}s to average.}

\item{param_vals}{\code{(list())} \cr
Parameters, including weights, to pass to \link{PipeOpSurvAvg}.}

\item{graph_learner}{\code{logical(1)}\cr
If \code{TRUE} returns wraps the \link[mlr3pipelines:Graph]{Graph} as a
\link[mlr3pipelines:mlr_learners_graph]{GraphLearner} otherwise (default) returns as a \code{Graph}.}
}
\value{
\link[mlr3pipelines:Graph]{mlr3pipelines::Graph} or \link[mlr3pipelines:mlr_learners_graph]{mlr3pipelines::GraphLearner}
}
\description{
Wrapper around \link{PipeOpSurvAvg} to simplify \link[mlr3pipelines:Graph]{Graph} creation.
}
\examples{
\dontrun{
if (requireNamespace("mlr3pipelines", quietly = TRUE)) {
library("mlr3")
library("mlr3pipelines")

task = tsk("rats")
pipe = ppl(
  "survaverager",
  learners = lrns(c("surv.kaplan", "surv.coxph")),
  param_vals = list(weights = c(0.1, 0.9)),
  graph_learner = FALSE
 )
pipe$train(task)
pipe$predict(task)
}
}
}
\seealso{
Other pipelines: 
\code{\link{mlr_graphs_crankcompositor}},
\code{\link{mlr_graphs_distrcompositor}},
\code{\link{mlr_graphs_probregrcompositor}},
\code{\link{mlr_graphs_survbagging}},
\code{\link{mlr_graphs_survtoregr}}
}
\concept{pipelines}
