% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTransformer.R
\name{PipeOpTransformer}
\alias{PipeOpTransformer}
\title{PipeOpTransformer}
\description{
Parent class for \link[mlr3pipelines:PipeOp]{PipeOp}s that transform \link[mlr3:Task]{Task} and \link[mlr3:Prediction]{Prediction}
objects to different types.
}
\section{Input and Output Channels}{

Determined by child classes.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Internals}{

The commonality of methods using \link{PipeOpTransformer} is that they take a \link[mlr3:Task]{Task}
or \link[mlr3:Prediction]{Prediction} of one type (e.g. regr or classif) and transform it to
another type.
}

\seealso{
Other PipeOps: 
\code{\link{PipeOpPredTransformer}},
\code{\link{PipeOpTaskTransformer}},
\code{\link{mlr_pipeops_survavg}},
\code{\link{mlr_pipeops_trafopred_regrsurv}},
\code{\link{mlr_pipeops_trafopred_survregr}},
\code{\link{mlr_pipeops_trafotask_regrsurv}},
\code{\link{mlr_pipeops_trafotask_survregr}}

Other Transformers: 
\code{\link{PipeOpPredTransformer}},
\code{\link{PipeOpTaskTransformer}}
}
\concept{PipeOps}
\concept{Transformers}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpTransformer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpTransformer$new()}}
\item \href{#method-clone}{\code{PipeOpTransformer$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTransformer$new(
  id,
  param_set = ps(),
  param_vals = list(),
  packages = character(),
  input = data.table(),
  output = data.table()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Set of hyperparameters.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled by the constructor if at least one of the packages is not installed,
but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}

\item{\code{input}}{\link[data.table:data.table]{data.table::data.table}\cr
\code{data.table} with columns \code{name} (\code{character}), \code{train} (\code{character}), \code{predict} (\code{character}).
Sets the \verb{$input} slot, see \link[mlr3pipelines:PipeOp]{PipeOp}.}

\item{\code{output}}{\link[data.table:data.table]{data.table::data.table}\cr
\code{data.table} with columns \code{name} (\code{character}), \code{train} (\code{character}), \code{predict} (\code{character}).
Sets the \verb{$output} slot, see \link[mlr3pipelines:PipeOp]{PipeOp}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTransformer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
