% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{mlr3spatiotempcv-package}
\alias{mlr3spatiotempcv}
\alias{mlr3spatiotempcv-package}
\title{mlr3spatiotempcv: Spatiotemporal Resampling Methods for 'mlr3'}
\description{
Extends the mlr3 ML framework with spatio-temporal resampling methods to account for the presence of spatiotemporal autocorrelation (STAC) in predictor variables. STAC may cause highly biased performance estimates in cross-validation if ignored.
}
\section{Main resources}{

\itemize{
\item Book on mlr3: \url{https://mlr3book.mlr-org.com}
\item mlr3book section about spatiotemporal data: \url{https://mlr3book.mlr-org.com/special-tasks.html#spatiotemporal}
\item package vignettes: \url{https://mlr3spatiotempcv.mlr-org.com/dev/articles/}
}
\subsection{Miscellaneous \pkg{mlr3} content}{
\itemize{
\item Use cases and examples: \url{https://mlr3gallery.mlr-org.com}
\item More classification and regression tasks: \CRANpkg{mlr3data}
\item Connector to \href{https://www.openml.org}{OpenML}: \CRANpkg{mlr3oml}
\item More classification and regression learners: \CRANpkg{mlr3learners}
\item Even more learners: \url{https://github.com/mlr-org/mlr3extralearners}
\item Preprocessing and machine learning pipelines: \CRANpkg{mlr3pipelines}
\item Tuning of hyperparameters: \CRANpkg{mlr3tuning}
\item Visualizations for many \pkg{mlr3} objects: \CRANpkg{mlr3viz}
\item Survival analysis and probabilistic regression: \CRANpkg{mlr3proba}
\item Cluster analysis: \CRANpkg{mlr3cluster}
\item Feature selection filters: \CRANpkg{mlr3filters}
\item Feature selection wrappers: \CRANpkg{mlr3fselect}
\item Interface to real (out-of-memory) data bases: \CRANpkg{mlr3db}
\item Performance measures as plain functions: \CRANpkg{mlr3measures}
\item Parallelization framework: \CRANpkg{future}
\item Progress bars: \CRANpkg{progressr}
}
}
}

\references{
Schratz P, Muenchow J, Iturritxa E, Richter J, Brenning A (2019).
\dQuote{Hyperparameter tuning and performance assessment of statistical and machine-learning algorithms using spatial data.}
\emph{Ecological Modelling}, \bold{406}, 109--120.
\doi{10.1016/j.ecolmodel.2019.06.002}.

Valavi R, Elith J, Lahoz-Monfort JJ, Guillera-Arroita G (2018).
\dQuote{blockCV: an R package for generating spatially or environmentally separated folds for k-fold cross-validation of species distribution models.}
\emph{bioRxiv}.
\doi{10.1101/357798}.

Meyer H, Reudenbach C, Hengl T, Katurji M, Nauss T (2018).
\dQuote{Improving performance of spatio-temporal machine learning models using forward feature selection and target-oriented validation.}
\emph{Environmental Modelling & Software}, \bold{101}, 1--9.
\doi{10.1016/j.envsoft.2017.12.001}.

Zhao Y, Karypis G (2002).
\dQuote{Evaluation of Hierarchical Clustering Algorithms for Document Datasets.}
\emph{11th Conference of Information and Knowledge Management (CIKM)}, 51-524.
\url{http://glaros.dtc.umn.edu/gkhome/node/167}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://mlr3spatiotempcv.mlr-org.com/}
  \item \url{https://github.com/mlr-org/mlr3spatiotempcv}
  \item \url{https://mlr3book.mlr-org.com}
  \item Report bugs at \url{https://github.com/mlr-org/mlr3spatiotempcv/issues}
}

}
\author{
\strong{Maintainer}: Patrick Schratz \email{patrick.schratz@gmail.com} (\href{https://orcid.org/0000-0003-0748-6624}{ORCID})

Authors:
\itemize{
  \item Marc Becker \email{marcbecker@posteo.de} (\href{https://orcid.org/0000-0002-8115-0400}{ORCID})
}

Other contributors:
\itemize{
  \item Jannes Muenchow \email{jannes.muenchow@uni-jena.de} (\href{https://orcid.org/0000-0001-7834-4717}{ORCID}) [contributor]
  \item Michel Lang \email{michellang@gmail.com} (\href{https://orcid.org/0000-0001-9754-0393}{ORCID}) [contributor]
}

}
