% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContextTorch.R
\name{mlr_context_torch}
\alias{mlr_context_torch}
\alias{ContextTorch}
\title{Context for Torch Learner}
\description{
Context for training a torch learner.
This is the - mostly read-only - information callbacks have access to through the argument \code{ctx}.
For more information on callbacks, see \code{\link{CallbackSet}}.
}
\seealso{
Other Callback: 
\code{\link{TorchCallback}},
\code{\link{as_torch_callback}()},
\code{\link{as_torch_callbacks}()},
\code{\link{callback_set}()},
\code{\link{mlr3torch_callbacks}},
\code{\link{mlr_callback_set}},
\code{\link{mlr_callback_set.checkpoint}},
\code{\link{mlr_callback_set.progress}},
\code{\link{t_clbk}()},
\code{\link{torch_callback}()}
}
\concept{Callback}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{learner}}{(\code{\link[mlr3:Learner]{Learner}})\cr
The torch learner.}

\item{\code{task_train}}{(\code{\link[mlr3:Task]{Task}})\cr
The training task.}

\item{\code{task_valid}}{(\code{\link[mlr3:Task]{Task}} or \code{NULL})\cr
The validation task.}

\item{\code{loader_train}}{(\code{\link[torch:dataloader]{torch::dataloader}})\cr
The data loader for training.}

\item{\code{loader_valid}}{(\code{\link[torch:dataloader]{torch::dataloader}})\cr
The data loader for validation.}

\item{\code{measures_train}}{(\code{list()} of \code{\link[mlr3:Measure]{Measure}}s)\cr
Measures used for training.}

\item{\code{measures_valid}}{(\code{list()} of \code{\link[mlr3:Measure]{Measure}}s)\cr
Measures used for validation.}

\item{\code{network}}{(\code{\link[torch:nn_module]{torch::nn_module}})\cr
The torch network.}

\item{\code{optimizer}}{(\code{\link[torch:optimizer]{torch::optimizer}})\cr
The optimizer.}

\item{\code{loss_fn}}{(\code{\link[torch:nn_module]{torch::nn_module}})\cr
The loss function.}

\item{\code{total_epochs}}{(\code{integer(1)})\cr
The total number of epochs the learner is trained for.}

\item{\code{last_scores_train}}{(named \code{list()} or \code{NULL})\cr
The scores from the last training batch. Names are the ids of the training measures.
If \code{\link{LearnerTorch}} sets \code{eval_freq} different from \code{1}, this is \code{NULL} in all epochs
that don't evaluate the model.}

\item{\code{last_scores_valid}}{(\code{list()})\cr
The scores from the last validation batch. Names are the ids of the validation measures.
If \code{\link{LearnerTorch}} sets \code{eval_freq} different from \code{1}, this is \code{NULL} in all epochs
that don't evaluate the model.}

\item{\code{epoch}}{(\code{integer(1)})\cr
The current epoch.}

\item{\code{step}}{(\code{integer(1)})\cr
The current iteration.}

\item{\code{prediction_encoder}}{(\verb{function()})\cr
The learner's prediction encoder.}

\item{\code{batch}}{(named \code{list()} of \code{torch_tensor}s)\cr
The current batch.}

\item{\code{terminate}}{(\code{logical(1)})\cr
If this field is set to \code{TRUE} at the end of an epoch, training stops.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ContextTorch-new}{\code{ContextTorch$new()}}
\item \href{#method-ContextTorch-clone}{\code{ContextTorch$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextTorch-new"></a>}}
\if{latex}{\out{\hypertarget{method-ContextTorch-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextTorch$new(
  learner,
  task_train,
  task_valid = NULL,
  loader_train,
  loader_valid = NULL,
  measures_train = NULL,
  measures_valid = NULL,
  network,
  optimizer,
  loss_fn,
  total_epochs,
  prediction_encoder,
  eval_freq = 1L
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner}}{(\code{\link[mlr3:Learner]{Learner}})\cr
The torch learner.}

\item{\code{task_train}}{(\code{\link[mlr3:Task]{Task}})\cr
The training task.}

\item{\code{task_valid}}{(\code{\link[mlr3:Task]{Task}} or \code{NULL})\cr
The validation task.}

\item{\code{loader_train}}{(\code{\link[torch:dataloader]{torch::dataloader}})\cr
The data loader for training.}

\item{\code{loader_valid}}{(\code{\link[torch:dataloader]{torch::dataloader}} or \code{NULL})\cr
The data loader for validation.}

\item{\code{measures_train}}{(\code{list()} of \code{\link[mlr3:Measure]{Measure}}s or \code{NULL})\cr
Measures used for training. Default is \code{NULL}.}

\item{\code{measures_valid}}{(\code{list()} of \code{\link[mlr3:Measure]{Measure}}s or \code{NULL})\cr
Measures used for validation.}

\item{\code{network}}{(\code{\link[torch:nn_module]{torch::nn_module}})\cr
The torch network.}

\item{\code{optimizer}}{(\code{\link[torch:optimizer]{torch::optimizer}})\cr
The optimizer.}

\item{\code{loss_fn}}{(\code{\link[torch:nn_module]{torch::nn_module}})\cr
The loss function.}

\item{\code{total_epochs}}{(\code{integer(1)})\cr
The total number of epochs the learner is trained for.}

\item{\code{prediction_encoder}}{(\verb{function()})\cr
The learner's prediction encoder.}

\item{\code{eval_freq}}{(\code{integer(1)})\cr
The evaluation frequency.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextTorch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ContextTorch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextTorch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
