% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TorchCallback.R
\name{t_clbk}
\alias{t_clbk}
\alias{t_clbks}
\title{Sugar Function for Torch Callback}
\usage{
t_clbk(.key, ...)

t_clbks(.keys)
}
\arguments{
\item{.key}{(\code{character(1)})\cr
The key of the torch callback.}

\item{...}{(any)\cr
See description of \code{\link[mlr3misc:dictionary_sugar_get]{dictionary_sugar_get()}}.}

\item{.keys}{(\code{character()})\cr
The keys of the callbacks.}
}
\value{
\code{\link{TorchCallback}}

\code{list()} of \code{\link{TorchCallback}}s
}
\description{
Retrieves one or more \code{\link{TorchCallback}}s from \code{\link{mlr3torch_callbacks}}.
Works like \code{\link[mlr3:mlr_sugar]{mlr3::lrn()}} and \code{\link[mlr3:mlr_sugar]{mlr3::lrns()}}.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
t_clbk("progress")
\dontshow{\}) # examplesIf}
}
\seealso{
Other Callback: 
\code{\link{TorchCallback}},
\code{\link{as_torch_callback}()},
\code{\link{as_torch_callbacks}()},
\code{\link{callback_set}()},
\code{\link{mlr3torch_callbacks}},
\code{\link{mlr_callback_set}},
\code{\link{mlr_callback_set.checkpoint}},
\code{\link{mlr_callback_set.progress}},
\code{\link{mlr_context_torch}},
\code{\link{torch_callback}()}

Other Torch Descriptor: 
\code{\link{TorchCallback}},
\code{\link{TorchDescriptor}},
\code{\link{TorchLoss}},
\code{\link{TorchOptimizer}},
\code{\link{as_torch_callbacks}()},
\code{\link{as_torch_loss}()},
\code{\link{as_torch_optimizer}()},
\code{\link{mlr3torch_losses}},
\code{\link{mlr3torch_optimizers}},
\code{\link{t_loss}()},
\code{\link{t_opt}()}
}
\concept{Callback}
\concept{Torch Descriptor}
