% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackSetProgress.R
\name{mlr_callback_set.progress}
\alias{mlr_callback_set.progress}
\alias{CallbackSetProgress}
\title{Progress Callback}
\description{
Prints a progress bar and the metrics for training and validation.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
task = tsk("iris")

learner = lrn("classif.mlp", epochs = 5, batch_size = 1,
  callbacks = t_clbk("progress"), validate = 0.3)
learner$param_set$set_values(
  measures_train = msrs(c("classif.acc", "classif.ce")),
  measures_valid = msr("classif.ce")
)

learner$train(task)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Callback: 
\code{\link{TorchCallback}},
\code{\link{as_torch_callback}()},
\code{\link{as_torch_callbacks}()},
\code{\link{callback_set}()},
\code{\link{mlr3torch_callbacks}},
\code{\link{mlr_callback_set}},
\code{\link{mlr_callback_set.checkpoint}},
\code{\link{mlr_callback_set.tb}},
\code{\link{mlr_callback_set.unfreeze}},
\code{\link{mlr_context_torch}},
\code{\link{t_clbk}()},
\code{\link{torch_callback}()}
}
\concept{Callback}
\section{Super class}{
\code{\link[mlr3torch:CallbackSet]{mlr3torch::CallbackSet}} -> \code{CallbackSetProgress}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CallbackSetProgress-on_epoch_begin}{\code{CallbackSetProgress$on_epoch_begin()}}
\item \href{#method-CallbackSetProgress-on_batch_end}{\code{CallbackSetProgress$on_batch_end()}}
\item \href{#method-CallbackSetProgress-on_before_valid}{\code{CallbackSetProgress$on_before_valid()}}
\item \href{#method-CallbackSetProgress-on_batch_valid_end}{\code{CallbackSetProgress$on_batch_valid_end()}}
\item \href{#method-CallbackSetProgress-on_epoch_end}{\code{CallbackSetProgress$on_epoch_end()}}
\item \href{#method-CallbackSetProgress-on_end}{\code{CallbackSetProgress$on_end()}}
\item \href{#method-CallbackSetProgress-clone}{\code{CallbackSetProgress$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="CallbackSet" data-id="load_state_dict"><a href='../../mlr3torch/html/CallbackSet.html#method-CallbackSet-load_state_dict'><code>mlr3torch::CallbackSet$load_state_dict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="CallbackSet" data-id="print"><a href='../../mlr3torch/html/CallbackSet.html#method-CallbackSet-print'><code>mlr3torch::CallbackSet$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="CallbackSet" data-id="state_dict"><a href='../../mlr3torch/html/CallbackSet.html#method-CallbackSet-state_dict'><code>mlr3torch::CallbackSet$state_dict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetProgress-on_epoch_begin"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetProgress-on_epoch_begin}{}}}
\subsection{Method \code{on_epoch_begin()}}{
Initializes the progress bar for training.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetProgress$on_epoch_begin()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetProgress-on_batch_end"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetProgress-on_batch_end}{}}}
\subsection{Method \code{on_batch_end()}}{
Increments the training progress bar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetProgress$on_batch_end()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetProgress-on_before_valid"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetProgress-on_before_valid}{}}}
\subsection{Method \code{on_before_valid()}}{
Creates the progress bar for validation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetProgress$on_before_valid()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetProgress-on_batch_valid_end"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetProgress-on_batch_valid_end}{}}}
\subsection{Method \code{on_batch_valid_end()}}{
Increments the validation progress bar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetProgress$on_batch_valid_end()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetProgress-on_epoch_end"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetProgress-on_epoch_end}{}}}
\subsection{Method \code{on_epoch_end()}}{
Prints a summary of the training and validation process.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetProgress$on_epoch_end()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetProgress-on_end"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetProgress-on_end}{}}}
\subsection{Method \code{on_end()}}{
Prints the time at the end of training.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetProgress$on_end()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetProgress-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetProgress-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetProgress$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
