% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distanceTransform}
\alias{distanceTransform}
\alias{distanceTransform.default}
\title{Distance transforms}
\usage{
distanceTransform(x, ...)

\method{distanceTransform}{default}(x, pixdim = TRUE, signed = FALSE, ...)
}
\arguments{
\item{x}{Any object. For the default method, this must be coercible to an
array.}

\item{\dots}{Additional arguments to methods.}

\item{pixdim}{An optional numeric vector or logical value. In the former
case it will be taken as giving the physical size of the array elements of
\code{x} along each dimension, and these will be incorporated into the
distance calculation. If \code{TRUE}, the default, the \code{"pixdim"}
attribute of \code{x} will be used for this purpose, if it is present. If
\code{FALSE}, any such attribute will be ignored, and distances will
always be counted in array elements, with all dimensions treated equally.}

\item{signed}{Logical value. If \code{TRUE}, the signed distance transform
is returned, such that distances from the region boundary are negative
within the region and positive outside. Otherwise, distances are zero
within the region.}
}
\value{
An array of the same dimension as the original, whose elements give
  the Euclidean distance from that element to the nearest "on" element in
  the original.
}
\description{
The Euclidean distance transform produces an array like its argument, but
with element values representing the Euclidean distance to the nearest
nonzero element. The input is treated as logically binary, with all nonzero
values treated as "on", and all zeroes as "off".
}
\examples{
x <- c(0,0,1,0,0,0,1,1,1,0,0)
distanceTransform(x)
distanceTransform(x, pixdim=2)
}
\references{
This implementation is based on the "marching parabolas"
  algorithm described by Felzenszwalb and Huttenlocher in the paper below.
  
  P.F. Felzenszwalb & D.P. Huttenlocher (2012). Distance transforms of
  sampled functions. Theory of Computing 8(19):415-428.
}
\author{
Jon Clayden <code@clayden.org>
}
