% Generated by roxygen2 (4.0.1): do not edit by hand
\name{phi.direct.ct}
\alias{phi.direct.ct}
\title{Variance components for Model 3}
\usage{
phi.direct.ct(p, sigmap, X, theta, phi1, phi2, u1, u2, rho)
}
\arguments{
\item{p}{vector with the number of auxiliary variables per category.}

\item{sigmap}{a list with the model variance-covariance matrices for each domain obtained from \code{\link[mme]{wmatrix}}.}

\item{X}{list of matrices with the auxiliary variables obtained from \code{\link[mme]{data.mme}}. The dimension of the list is the number of categories of the response variable minus one.}

\item{theta}{matrix with the estimated log-probabilites of each category in front of the reference category obtained from \code{\link[mme]{prmu.time}}.}

\item{phi1}{vector with the initial values of the first variance component obtained from \code{\link[mme]{modelfit3}}.}

\item{phi2}{vector with the initial values of the second variance component obtained from \code{\link[mme]{modelfit3}}.}

\item{u1}{matrix with the values of the first random effect obtained from \code{\link[mme]{modelfit3}}.}

\item{u2}{matrix with the values of the second random effect obtained from \code{\link[mme]{modelfit3}}.}

\item{rho}{vector with the initial values of the correlation parameter obtained from \code{\link[mme]{modelfit3}}.}
}
\value{
a list containing the following components.
\item{phi1.new}{vector with the values of the variance component for the first random effect.}
\item{phi2.new}{vector with the values of the variance component for the second random effect.}
\item{rho.new}{vector with the correlation parameter.}
}
\description{
This function calculates the variance components for the multinomial mixed model with two independent random effects
for each category of the response variable: one domain random effect and another correlated time and domain random effect (Model 3). This variance components
are used in the second part of the fitting algorithm
implemented in \code{\link[mme]{modelfit3}}. The algorithm adapts the ideas of Schall (1991) to a multivariate model. The variance components are
estimated by the REML method.
}
\examples{
k=3 #number of categories of the response variable
pp=c(1,1) #vector with the number of auxiliary variables in each category
mod=3 #type of model
data(simdata3) #data
datar=data.mme(simdata3,k,pp,mod)
initial=datar$initial
mean=prmu.time(datar$n,datar$Xk,initial$beta.0,initial$u1.0,initial$u2.0)
sigmap=wmatrix(datar$n,mean$estimated.probabilities)

##The variance components
phi.ct=phi.direct.ct(pp,sigmap,datar$X,mean$eta,initial$phi1.0,
       initial$phi2.0,initial$u1.0,initial$u2.0,initial$rho.0)
}
\references{
Lopez-Vizcaino, ME, Lombardia, MJ and Morales, D (2013).
Small area estimation of labour force indicator under a multinomial mixed model
with correlated time and area effects. Submitted for review.

Schall, R (1991). Estimation in generalized linear models with
random effects. Biometrika,
78,719-727.
}
\seealso{
\code{\link[mme]{data.mme}}, \code{\link[mme]{initial.values}},
\code{\link[mme]{wmatrix}}, \code{\link[mme]{phi.mult.ct}},
\code{\link[mme]{prmu.time}}, \code{\link[mme]{Fbetaf.ct}}
\code{\link[mme]{sPhikf.ct}}, \code{\link[mme]{ci}},
\code{\link[mme]{modelfit3}}, \code{\link[mme]{msef.ct}},
\code{\link[mme]{mseb}}, \code{\link[mme]{omega}}
}
\keyword{models}

