% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_game_mgmt.R
\name{interpret_replication_results}
\alias{interpret_replication_results}
\title{Interpretation of Replication Study Results}
\usage{
interpret_replication_results(
  replication_results,
  bf_threshold = 3,
  pmpb_threshold = 0.8
)
}
\arguments{
\item{replication_results}{A list containing the results of a replication study,
specifically a bain object with BF and PMPb values.}

\item{bf_threshold}{The threshold for the Bayes factor (BF.c) above which the
evidence is considered strong. Default is 3.}

\item{pmpb_threshold}{The threshold for the posterior model probabilities (PMPb)
above which the evidence is considered strong. Default is 0.80.}
}
\value{
A list with elements 'interpretation' providing the interpretative
message, 'result' indicating a 'win' or 'lose' based on the interpretation, and
'disclaimer' providing a contextual disclaimer.
}
\description{
This function interprets the results of a replication study by applying Bayes
factor (BF) and posterior model probabilities (PMPb) thresholds. It checks
against predefined thresholds to determine if there is strong evidence for the
hypotheses derived from the original study.
}
\details{
The function first checks for the presence of a secondary hypothesis (H2) in
the analysis results. If H2 is present, it will prioritize its interpretation;
otherwise, it defaults to interpreting H1. Interpretation is based on whether
the BF.c and PMPb values exceed their respective thresholds.

A 'win' result means there is strong evidence for the hypothesis, while a 'lose'
indicates the evidence is inconclusive or not strong enough.

The function includes a disclaimer about the use of threshold values for
hypothesis testing and recommends consulting the cited literature for a
comprehensive understanding of Bayesian factors and informative hypothesis
testing.
}
\note{
The thresholds used in this function are for educational purposes within
the context of a game and should not be taken as rigid rules for hypothesis
testing in practice.
}
\examples{
# Original study
os_deck <- deal_cards_to_rc_grid(n = 3)
original_study_data <- generate_study_data(os_deck, sample_size = 100)
original_study_results <- process_original_study(original_study_data)

# Replication study
rs_deck <- deal_cards_to_rc_grid(n = 3)
replication_data <- generate_study_data(rs_deck, sample_size = 100)
replication_results <- process_replication_study(replication_data,
                                                 original_study_results)

interpret_replication_results(replication_results)
}
