% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_helpers.R
\name{runSimulation}
\alias{runSimulation}
\title{Execute Simulation Based on User Input}
\usage{
runSimulation(input)
}
\arguments{
\item{input}{A list containing the user input parameters from the Shiny application.}
}
\value{
The result of the simulation, which can be either from \code{replext_t1_c1}
(Order Constrained ANOVA) or \code{replext_t2_c1} (Inequality Constrained Linear
Regression), depending on the selected cell block.
}
\description{
This internal helper function runs the appropriate simulation function based
on the user-selected cell block in the Replext Shiny application. It handles
the dynamic execution of either ANOVA or regression simulations based on the
parameters specified by the user.
}
\details{
The function first checks and sets the random number seed if provided.
It then determines which simulation function to call (\code{replext_t1_c1} or
\code{replext_t2_c1}) based on the prefix of the \code{cellBlock} input parameter.
The function passes user-specified parameters to the chosen simulation
function and returns the simulation results.
}
\keyword{internal}
