% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_joined_between.R
\name{mnis_joined_between}
\alias{mnis_joined_between}
\title{mnis_joined_between}
\usage{
mnis_joined_between(startDate = "1900-01-01", endDate = Sys.Date(),
  house = "all", party = NULL, eligible = "all", tidy = TRUE)
}
\arguments{
\item{startDate}{The start date of the search, in yyyy-mm-dd format. Defaults to '1900-01-01'.}

\item{endDate}{The end date of the search, in yyyy-mm-dd format. Defaults to the current date.}

\item{house}{The house to which the member belongs. Accepts one of 'all', 'lords' and 'commons', defaults to 'all'.}

\item{party}{The party to which a member belongs. Defaults to NULL.}

\item{eligible}{If the member is currently eligible to sit. Accepts one of 'all', 'current', 'former', defaults to 'all'.}

\item{tidy}{Fix the variable names in the data frame to remove '@' characters and superfluous text. Defaults to FALSE.}
}
\description{
Function returns all members who took their seats in the house between two given dates. The function requests data in JSON format and parses it to a data frame. The
}
\examples{
\dontrun{
x <- mnis_joined_between(startDate = '2015-01-01', endDate ='2017-01-01',
                         house='all', party='labour', eligible='all')

}
}
\keyword{mnis}
