% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_extra.R
\name{mnis_extra}
\alias{mnis_extra}
\title{mnis_extra}
\usage{
mnis_extra(ID, mnis_id = TRUE, ref_dods = FALSE, addresses = TRUE,
  basic_details = TRUE, biography_entries = TRUE, committees = TRUE,
  constituencies = TRUE, elections_contested = TRUE, experiences = TRUE,
  government_posts = TRUE, honours = TRUE, house_memberships = TRUE,
  interests = TRUE, known_as = TRUE, maiden_speeches = TRUE,
  opposition_posts = TRUE, other_parliaments = TRUE,
  parliamentary_posts = TRUE, parties = TRUE, preferred_names = TRUE,
  staff = TRUE, statuses = TRUE, tidy = TRUE)
}
\arguments{
\item{ID}{The ID number of the member. Defaults to NULL.}

\item{mnis_id}{Request based on the default membership ID scheme.}

\item{ref_dods}{Request based on the DODS membership ID scheme. Defaults to FALSE.}

\item{addresses}{Member address information (e.g. website, twitter, consituency address etc...).}

\item{basic_details}{Basic information about the Member (e.g. given name, HoL membership type, oaths etc...)}

\item{biography_entries}{Member biographical information (e.g. countries of interest, policy expertise etc...)}

\item{committees}{Committees a Member sits or has sat on as well details on committee chairing.}

\item{constituencies}{constituencies a Member has represented.}

\item{elections_contested}{Elections a Member has contested but not won.}

\item{experiences}{Non-parliamentary experience of a Member.}

\item{government_posts}{Government posts a Member currently holds.}

\item{honours}{Honours (e.g. MBE, OBE etc...) held by a Member.}

\item{house_memberships}{House membership list of a Member.}

\item{interests}{Registered interests (financial) of a Member.}

\item{known_as}{Details of names a Member has chosen to be known as instead of their full title (House of Lords members only).}

\item{maiden_speeches}{Maiden speech dates for a Member.}

\item{opposition_posts}{Opposition posts a Member has held.}

\item{other_parliaments}{Other Parliaments that a Member has held a membership of.}

\item{parliamentary_posts}{Parliamentary posts a Member has held.}

\item{parties}{Party affiliations of a Member.}

\item{preferred_names}{Full set of data about a Members' name (e.g. surname, forename, Honorary prefixes, full details of HoL title and rank etc...).}

\item{staff}{The staff employed by a Member.}

\item{statuses}{Status history (e.g. suspensions and disqualifications) for a Member.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to snake_case. Defaults to TRUE.}
}
\value{
A tibble with data on a given MP.
}
\description{
A wrapper for \code{\link{mnis_additional}} functions. It combines the various options of mnis_additional into one dataframe, and the default is similar to \code{\link{mnis_full_biog}}.
Variable descriptions are taken from the mnis website: <http://data.parliament.uk/membersdataplatform/memberquery.aspx>
}
\examples{
\dontrun{

x <- mnis_extra(172)

}
}
\seealso{
\code{\link{mnis_full_biog}} \code{\link{mnis_basic_details}} \code{\link{mnis_additional}}
}
\keyword{mnis}
