% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_reference.R
\name{mnis_reference}
\alias{mnis_reference}
\alias{ref_address_types}
\alias{ref_answering_bodies}
\alias{ref_areas}
\alias{ref_area_types}
\alias{ref_biography_categories}
\alias{ref_cabinets}
\alias{ref_committees}
\alias{ref_committee_types}
\alias{ref_constituencies}
\alias{ref_constituency_areas}
\alias{ref_constituency_types}
\alias{ref_countries}
\alias{ref_departments}
\alias{ref_disqualification_types}
\alias{ref_elections}
\alias{ref_election_types}
\alias{ref_end_reasons}
\alias{ref_experience_types}
\alias{ref_government_post_departments}
\alias{ref_government_posts}
\alias{ref_government_ranks}
\alias{ref_honourary_prefixes}
\alias{ref_honour_lists}
\alias{ref_honours}
\alias{ref_interest_categories}
\alias{ref_lords_membership_types}
\alias{ref_lords_ranks}
\alias{ref_opposition_post_departments}
\alias{ref_opposition_posts}
\alias{ref_opposition_ranks}
\alias{ref_other_parliaments}
\alias{ref_parliamentary_posts}
\alias{ref_parliamentary_ranks}
\alias{ref_parliament_types}
\alias{ref_parties}
\alias{ref_party_sub_types}
\alias{ref_photo_outputs}
\alias{ref_statuses}
\alias{ref_titles}
\title{mnis_reference}
\usage{
mnis_reference()

ref_address_types(tidy = TRUE, tidy_style = "snake_case")

ref_answering_bodies(tidy = TRUE, tidy_style = "snake_case")

ref_areas(tidy = TRUE, tidy_style = "snake_case")

ref_area_types(tidy = TRUE, tidy_style = "snake_case")

ref_biography_categories(tidy = TRUE, tidy_style = "snake_case")

ref_cabinets(tidy = TRUE, tidy_style = "snake_case")

ref_committees(tidy = TRUE, tidy_style = "snake_case")

ref_committee_types(tidy = TRUE, tidy_style = "snake_case")

ref_constituencies(tidy = TRUE, tidy_style = "snake_case")

ref_constituency_areas(tidy = TRUE, tidy_style = "snake_case")

ref_constituency_types(tidy = TRUE, tidy_style = "snake_case")

ref_countries(tidy = TRUE, tidy_style = "snake_case")

ref_departments(tidy = TRUE, tidy_style = "snake_case")

ref_disqualification_types(tidy = TRUE, tidy_style = "snake_case")

ref_elections(tidy = TRUE, tidy_style = "snake_case")

ref_election_types(tidy = TRUE, tidy_style = "snake_case")

ref_end_reasons(tidy = TRUE, tidy_style = "snake_case")

ref_experience_types(tidy = TRUE, tidy_style = "snake_case")

ref_government_post_departments(tidy = TRUE, tidy_style = "snake_case")

ref_government_posts(tidy = TRUE, tidy_style = "snake_case")

ref_government_ranks(tidy = TRUE, tidy_style = "snake_case")

ref_honourary_prefixes(tidy = TRUE, tidy_style = "snake_case")

ref_honour_lists(tidy = TRUE, tidy_style = "snake_case")

ref_honours(tidy = TRUE, tidy_style = "snake_case")

ref_interest_categories(tidy = TRUE, tidy_style = "snake_case")

ref_lords_membership_types(tidy = TRUE, tidy_style = "snake_case")

ref_lords_ranks(tidy = TRUE, tidy_style = "snake_case")

ref_opposition_post_departments(tidy = TRUE, tidy_style = "snake_case")

ref_opposition_posts(tidy = TRUE, tidy_style = "snake_case")

ref_opposition_ranks(tidy = TRUE, tidy_style = "snake_case")

ref_other_parliaments(tidy = TRUE, tidy_style = "snake_case")

ref_parliamentary_posts(tidy = TRUE, tidy_style = "snake_case")

ref_parliamentary_ranks(tidy = TRUE, tidy_style = "snake_case")

ref_parliament_types(tidy = TRUE, tidy_style = "snake_case")

ref_parties(tidy = TRUE, tidy_style = "snake_case")

ref_party_sub_types(tidy = TRUE, tidy_style = "snake_case")

ref_photo_outputs(tidy = TRUE, tidy_style = "snake_case")

ref_statuses(tidy = TRUE, tidy_style = "snake_case")

ref_titles(tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy=TRUE. Accepts one of "snake_case", "camelCase" and "period.case". Defaults to "snake_case"}
}
\description{
A series of 39 functions that return tibbles of reference data. This data is useful for providing parameters for other function calls. The functions do not accept any arguments aside from the 'tidy' argument, which defaults to TRUE.
}
\examples{
\dontrun{
ref_address_types()
# The types of addresses available in member's contact details.
# Includes websites and social media, as well as physical addresses.

ref_answering_bodies()
# The bodies that members' can address questions to.

ref_areas()
# Geographic areas.

ref_area_types()
# Identifiers for grouping areas (e.g. borough constituencies).

ref_biography_categories()
# Member biography categories.

ref_cabinets()
# Connections that a member has to the cabinet or shadow cabinet.

ref_committees()
# Identifier for parliamentary committees.

ref_committee_types()
# Types of parliamentary committees.

ref_constituencies()
# All constituencies.

ref_constituency_areas()
# The links between constituencies and constituency areas.

ref_constituency_types()
# Constituency categories.

ref_countries()
# List of countries that could be listed as members' birthplace.

ref_departments()
# Government and opposition departments.

ref_disqualification_types()
# Types of ways members can be disqualified from sitting in the House.

ref_elections()
# Codes of general and by-elections.

ref_election_types()
# Election categories.

ref_end_reasons()
# Reasons a member may leave the House of Lords or the House of Commons.

ref_experience_types()
# Types of non-parliamentary experience members can list.

ref_government_post_departments()
# All deparments that can contain government posts.

ref_government_posts()
# All government posts.

ref_government_ranks()
# All government post ranks.

ref_honourary_prefixes()
# The types of honourary prefixes for members.

ref_honour_lists()
# The types of honour lists that a member may be honoured in.

ref_honours()
# The different honours available to members.

ref_interest_categories()
# The categories available for reporting financial interests.

ref_lords_membership_types()
# Different types of membership of the House of Lords.

ref_lords_ranks()
# Ranks that peers may hold.

ref_opposition_post_departments()
# The link between opposition posts and the government department they shadow.

ref_opposition_posts()
# Opposition posts.

ref_opposition_ranks()
# How opposition posts are ranked.

ref_other_parliaments()
# Other parliaments that a member may have sat in.

ref_parliamentary_posts()
# The different parliamentary posts available.

ref_parliamentary_ranks()
# How those parliamentary posts are ranked.

ref_parliament_types()
# Types of parliaments that parliamentary data may link to.

ref_parties()
# All parties that members can be affiliated with.

ref_party_sub_types()
# Sub-types of parties.

ref_photo_outputs()
# Outputs that a photo of a member may be linked to.

ref_statuses()
# A member's possible current status in the House.

ref_titles()
# Salutory titles.

mnis_reference()
# Returns a list of all possible reference functions.
}

}
\keyword{mnis}
