% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{halton}
\alias{halton}
\title{Halton sequence}
\usage{
halton(
  n = 1L,
  base = as.integer(c(2)),
  start = 1L,
  random = "NO",
  type = "halton",
  scrambler = "NO",
  is_validation = TRUE,
  n_cores = 1L
)
}
\arguments{
\item{n}{positive integer representing the number of sequence elements.}

\item{base}{vector of positive integers greater then one representing
the bases for each of the sequences.}

\item{start}{non-negative integer representing the index of the first 
element of the sequence to be included in the output sequence.}

\item{random}{string representing the method of randomization to be
applied to the sequence. If \code{random = "NO"} (default) then
there is no randomization. If \code{random = "Tuffin"} then standard uniform
random variable will be added to each element of the sequence and 
the difference between this sum and it's 'floor' will be returned as
a new element of the sequence.}

\item{type}{string representing type of the sequence. Default is "halton"
that is Halton sequence. The alternative is "richtmyer" corresponding 
to Richtmyer sequence.}

\item{scrambler}{string representing scrambling method for the 
Halton sequence. Possible options are \code{"NO"} (default), \code{"root"}
and \code{"negroot"} which described in S. Kolenikov (2012).}

\item{is_validation}{logical value indicating whether input 
arguments should be validated.  Set it to \code{FALSE} to get
performance boost (default value is \code{TRUE}).}

\item{n_cores}{positive integer representing the number of CPU cores
used for parallel computing. Currently it is not recommended to set
\code{n_cores > 1} if vectorized arguments include less then 100000 elements.}
}
\value{
The function returns a matrix which \code{i}-th column
is a sequence with base \code{base[i]} and elements with indexes
from \code{start} to \code{start + n}.
}
\description{
Calculate elements of the Halton sequence and of
some other pseudo-random sequences.
}
\details{
Function \code{\link[mnorm]{seqPrimes}} could be used to
provide the prime numbers for the \code{base} input argument.
}
\examples{
halton(n = 100, base = c(2, 3, 5), start = 10)
}
\references{
J. Halton (1964) <doi:10.2307/2347972>

S. Kolenikov (2012) <doi:10.1177/1536867X1201200103>
}
