% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_algorithm.R
\name{ACCcalc}
\alias{ACCcalc}
\title{Reading Accessibility Index (ACC) calculation}
\usage{
ACCcalc(data, print_size, reading_time, errors, ... = NULL)
}
\arguments{
\item{data}{The name of your dataframe}

\item{print_size}{The variable that contains print size values for each sentence}

\item{reading_time}{The variable that contains the reading time for each sentence}

\item{errors}{The variable that contains the number of errors for each sentence}

\item{...}{Optional grouping arguments}
}
\value{
The function returns a new dataframe with a variable called "ACC" that contains the Reading Accessibility Index estimate.
}
\description{
This function calculates the Reading Accessibility Index, while applying suited rules for missing data.
}
\section{Notes}{

The Reading Accessibility Index (ACC) is a new measure representing an individual's access to text over the range of print sizes found in everyday life.
Its calculation does not rely on curve fitting and gives a direct comparison with the performance of normally sighted individuals.
The ACC calculation uses the print size values non corrected for non-standard viewing distance.

For more details on the Reading Accessibility Index, see \url{http://archopht.jamanetwork.com/article.aspx?articleid=2487490}
}

\section{Warning}{

To ensure that missing data are handled properly and that ACC calculation is correct, the data needs to be entered along certain rules:
 \itemize{
  \item For the smallest print size that is presented but not read, right before the test is stopped: \strong{rt = NA, err = 10}
  \item For all the small sentences that are not presented because the test was stopped before them: \strong{rt = NA, err = NA}
  \item If a sentence is presented, and read, but the time was not recorded by the experimenter: \strong{rt = NA, err = actual number of errors} (cf. s5-regular in low vision data sample)
  \item If a large sentence was skipped to save time but would have been read well: \strong{rt = NA, err = NA} (cf. s1-regular in normal vision data sample)
  \item If a large sentence was skipped to save time because the subject cannot read large print: \strong{rt = NA, err = 10} (cf. s7 in low vision data sample)
  }
}

\examples{
# inspect the structure of the dataframe
head(data_low_vision, 10)

#------

# restrict dataset to one MNREAD test only (subject s1, regular polarity)
data_s1 <- data_low_vision \%>\%
   filter (subject == "s1", polarity == "regular")

# run the reading accessibility index calculation
data_low_vision_ACC <- ACCcalc(data_s1, ps, rt, err)

# inspect the newly created dataframe
data_low_vision_ACC

#------

# run the reading accessibility index calculation
# on the whole dataset grouped by subject and polarity
data_low_vision_ACC <- ACCcalc(data_low_vision, ps, rt, err,
                               subject, polarity)

# inspect the structure of the newly created dataframe
head(data_low_vision_ACC, 10)

}
\seealso{
\code{\link{mnreadParam}} for all MNREAD parameters estimation

 \code{\link{curveParam}} for Maximum Reading Speed and Critical Print Size estimation

 \code{\link{readingAcuity}} for Reading Acuity calculation
}
