% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCA_singleValue.R
\name{OSCA_singleValue}
\alias{OSCA_singleValue}
\title{OSCA_singleValue}
\usage{
OSCA_singleValue(df, externalVar, oscaPath)
}
\arguments{
\item{df}{n x p dataframe or matrix of numeric -omics values with no ID column}

\item{externalVar}{vector of length n of external variable values with no ID column}

\item{oscaPath}{absolute path to OSCA software}
}
\value{
Row of OREML output containing percent variance explained in external data and standard error
}
\description{
Function to return the percent variance explained in an external phenotype for a single dataset
}
\details{
OmicS-data-based Complex trait Analysis (OSCA) is a suite of C++ functions. In order to use the OSCA functions, the user must specify the absolute path to the OSCA software, which can be downloaded from the Yang Lab website \href{https://yanglab.westlake.edu.cn/software/osca/#Download}{here}.

Here, we use OSCA's Omics Restricted Maximum Likelihood (OREML) method to estimate the percent of variance in an external phenotype that can be explained by an omics profile, akin to heritability estimates in GWAS.
}
\examples{
#load CCA package for example dataset
library(CCA)

# load dataset
data("nutrimouse")

# run function; input absolute path to OSCA software before running
\dontrun{OSCA_singleValue(df = nutrimouse$gene, 
                  externalVar = as.numeric(nutrimouse$diet),
                  oscaPath = "pathHere")}

}
\references{
Benjamini Y, Hochberg Y. Controlling the false discovery rate: a practical and powerful approach to multiple testing. \emph{Journal of the Royal statistical society: series B (Methodological)} \strong{57} (1995) 289–300.

Martin P, et al. Novel aspects of PPARalpha-mediated regulation of lipid and xenobiotic metabolism revealed through a nutrigenomic study. \emph{Hepatology}, in press, 2007.

Millstein J, Battaglin F, Barrett M, Cao S, Zhang W, Stintzing S, et al. Partition: a surjective mapping approach for dimensionality reduction. \emph{Bioinformatics} \strong{36} (2019) 676–681. doi:10.1093/bioinformatics/ btz661.

Queen K, Nguyen MN, Gilliland F, Chun S, Raby BA, Millstein J. ACDC: a general approach for detecting phenotype or exposure associated co-expression. (in press). \emph{Frontiers in Medicine} (2023).
}
\seealso{
OSCA software - \url{https://yanglab.westlake.edu.cn/software/osca/}
}
\author{
Katelyn Queen, \email{kjqueen@usc.edu}
}
