% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCTA_singleValue.R
\name{GCTA_singleValue}
\alias{GCTA_singleValue}
\title{GCTA_singleValue}
\usage{
GCTA_singleValue(
  fileLoc,
  externalVar,
  gctaPath,
  remlAlg = 0,
  maxRemlIt = 100,
  numCovars = NULL,
  catCovars = NULL
)
}
\arguments{
\item{fileLoc}{absolute file path to bed, bim, and fam files, including prefix}

\item{externalVar}{vector of length n of external variable values with no ID column; must be in the same sample order as bed, bim, fam files}

\item{gctaPath}{absolute path to GCTA software}

\item{remlAlg}{algorithm to run REML iterations in GCTA; 0 = average information (AI), 1 = Fisher-scoring, 2 = EM; default is 0 (AI)}

\item{maxRemlIt}{the maximum number of REML iterations; default is 100}

\item{numCovars}{n x c_n matrix of numerical covariates to adjust heritability model for; must be in same person order as fam file; default is NULL}

\item{catCovars}{n x c_c matrix of categorical covariates to adjust heritability model for; must be in same person order as fam file; default is NULL}
}
\value{
Row of GREML output containing heritability point estimate of external data and standard error
}
\description{
Function to return the heritability of an external phenotype for a single dataset
}
\details{
Genome-wide Complex Trait Analysis (GCTA) is a suite of C++ functions. In order to use the GCTA functions, the user must specify the absolute path to the GCTA software, which can be downloaded from the Yang Lab website \href{https://yanglab.westlake.edu.cn/software/gcta/#Download}{here}.

Here, we use GCTA's Genomics REstricted Maximum Likelihood (GREML) method to estimate the heritability of an external phenotype.
}
\examples{

externalVar <- c()

# run function; input data before running
\dontrun{OSCA_singleValue(fileLoc = "pathHere", 
                  externalVar = externalVar,
                  gctaPath = "pathHere")}

}
\references{
Yang J, Lee SH, Goddard ME, Visscher PM. GCTA: a tool for genome-wide complex trait analysis. Am J Hum Genet. 2011 Jan 7;88(1):76-82. doi: 10.1016/j.ajhg.2010.11.011. Epub 2010 Dec 17. PMID: 21167468; PMCID: PMC3014363.
}
\seealso{
GCTA software - \url{https://yanglab.westlake.edu.cn/software/gcta/}
}
\author{
Katelyn Queen, \email{kjqueen@usc.edu}
}
