% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modcmfitrFunctions.R
\name{fitModCM}
\alias{fitModCM}
\title{Fit modified Connor-Mosimann or Connor-Mosimann distribution}
\usage{
fitModCM(Outcomes, RawData, SearchParams, ModCMorCM, Quantiles)
}
\arguments{
\item{Outcomes}{A vector of names of outcomes}

\item{RawData}{matrix of lower, middle and upper quantiles for each dimension elicited from experts}

\item{SearchParams}{A vector of number of iterations and max number of searches.
Number of iterations is the number of draws from the mCM distribution used to estimate the quantiles.  Try 10,000 first.
Max number of searches is the maximum number of searches the search algorithm conducts.  The higher the better the fit, but also the longer it takes to find it.}

\item{ModCMorCM}{If =1, then will fit a modified CM.  If =0 then will fit a CM (i.e. forces lower and upper limits of each marginal scaled beta to 0 and 1 respectively)}

\item{Quantiles}{Sets the quantiles to be fit.  If median and 95\% Credibility Interval, then set to c(0.025,0.5,0.975).  If median and tertiles then (0.33,0.5,0.66).  If median and quartiles then c(0.25,0.5,0.75) and so on.}
}
\value{
Returns a matrix, each row representing one of the Outcomes.  Columns a, b, LL and UL are the parameters of the mCM distribution.  
Note that the final row will always be zeroes as the number of rows of the mCM distribution is k-1 where k is the number of outcomes.
The next three columns (Tgt_LL, Tgt_MED, Tgt_UL) are the target quantiles input to the function as 'RawData' in the example above.
The final three (Mdl_LL, Mdl_MED, Mdl_UL) are the quantiles resulting from the model fitting.  If the mCM is a good fit, the Mdl columns will be 
identical to the Tgt columns.
}
\description{
This function fits a modified CM distribution to an elicited set of quantiles from, e.g. an expert elicitation workshop.
The function uses the crs2lm() function from the nloptr package to search for the
set of hyperparameters that that generates quantiles that match the elicited data as closely as possible.
crs2lm() repeatedly calls TestFitModCM() until it finds the best fitting set of inputs.
The function returns a data frame containing the best fit set of hyperparameters for the Zeds, the Target quantiles and the modelled quantiles.
}
\examples{
Outcomes <- c("Remission","Progression","Dead")
RawData <- matrix(data = c(0.43, 0.55, 0.65,
                          0.16, 0.27, 0.46,
                          0.03, 0.18, 0.23
           ),ncol=3,byrow=TRUE)

SearchParams <- c(10000,100) #number of iterations, max number of searches

ModCMorCM <- 1

Quantiles <- c(0.025,0.5,0.975) # example here is 95\% credibility limits and median.

fitModCM(Outcomes, RawData, SearchParams, ModCMorCM, Quantiles)
}
\keyword{Connor-Mosimann}
\keyword{modified}
