% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmodel-methods.R
\name{objfun.pmodel.identity}
\alias{objfun.pmodel.identity}
\alias{logLik.pmodel.identity}
\title{Objective function of personalised models}
\usage{
\method{objfun}{pmodel.identity}(object, ...)

\method{logLik}{pmodel.identity}(object, add_df = 0, ...)
}
\arguments{
\item{object}{object of class pmodel.identity (obtained by \code{pmodel(..., fun = identity)}).}

\item{...}{additional parameters passed on to \code{\link{objfun}}.}

\item{add_df}{it is not very clear what the degrees of freedom are in personalised models.
With this argument you can add/substract degrees of freedom at your convenience. Default
is \code{0} which means adding up the degrees of freedom of all individual models.}
}
\description{
Get the contributions of an objective function (e.g. likelihood contributions)
and the sum thereof (e.g. log-Likelihood).
}
\details{
Note that \code{logLik.pmodel.identity} returns the sum of contributions and
thus not neccessarily the log-Likelihood, if the objective function is not
the log-Likelihood. For example if the base model is a linear model (\code{lm})
the objective function are the negative squared residuals and thus 
logLik.pmodel.identity will return the sum of squared residuals.

For examples see \code{\link{pmodel}}.
}
