% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-pmtree.R
\name{lm_plot}
\alias{lm_plot}
\title{Density plot for a given lm model
with one binary covariate.}
\usage{
lm_plot(mod, data = NULL, densest = FALSE, theme = theme_classic(),
  yrange = NULL)
}
\arguments{
\item{mod}{A model of class lm.}

\item{data}{optional data frame. If NULL the data stored in mod is used.}

\item{densest}{should additional to the model density kernel density estimates
(see \code{\link[ggplot2]{geom_density}}) be computed?}

\item{theme}{A ggplot2 theme.}

\item{yrange}{Range of the y variable to be used for plotting.
If NULL the range in the data will be used.}
}
\description{
Can be used on its own but is also useable as plotfun in
\code{\link{node_pmterminal}}.
}
\details{
In case of an offset, the value of the offset variable will be set to
the median of the values in the data.
}
\examples{
## example taken from ?lm
ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group <- gl(2, 10, 20, labels = c("Ctl","Trt"))
weight <- c(ctl, trt)
data <- data.frame(weight, group)
lm.D9 <- lm(weight ~ group, data = data)
lm_plot(lm.D9)

## example taken from ?glm (modified version)
data(anorexia, package = "MASS")
anorexia$treatment <- factor(anorexia$Treat != "Cont")
anorex.1 <- glm(Postwt ~ treatment + offset(Prewt),
                family = gaussian, data = anorexia)
lm_plot(anorex.1)

}
