% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_fordistribution.R
\name{convert.epipara.to.delappara}
\alias{convert.epipara.to.delappara}
\title{To convert model parameters}
\usage{
convert.epipara.to.delappara(
  para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = "D"
)
}
\arguments{
\item{para}{A list (\code{list}) of epidemiological parameters for offspring distribution, in the format of \code{list(mean = ?, disp = ?, shift = ?)},
where the three parameters accept non-negative values.
Each parameter can be either a scalar, or a vector.
For the parameters being assigned with values of vectors, the vectors should be of the same length.
For Delaporte distribution, the value of \code{mean} should be larger than the value of \code{shift}.}

\item{offspring.type}{A character label (\code{character}) indicating the type of distribution used to describe the offspring distribution.
It only accepts one of the following values:
\itemize{
\item{\code{"D"}}{ indicates the \emph{Delaporte} distribution, }
\item{\code{"NB"}}{ indicates the \emph{negative binomial} distribution, }
\item{\code{"G"}}{ indicates the \emph{geometric} distribution, or }
\item{\code{"P"}}{ indicates the \emph{Poisson} distribution.}
}
By default, \code{offspring.type = 'D'}.}
}
\value{
A list of statistical parameters in the format of \code{list(alpha = ?, beta = ?, lambda = ?)}
that can be recognized by Delaporte distribution.
}
\description{
This function (i.e., \code{convert.epipara.to.delappara()}) converts a list of pre-defined epidemiological parameters into a list of statistical parameters,
such that a probability function of Delaporte distribution may recognize, which is for \strong{internal use only}.
}
\details{
For different values of \code{offspring.type},
\itemize{
\item{When \code{offspring.type = "D"},}{ no action to the pre-defined epidemiological parameters; }
\item{When \code{offspring.type = "NB"},}{ we set parameter \code{shift = 0} internally; }
\item{When \code{offspring.type = "G"},}{ we set parameters \code{disp = 1} and \code{shift = 0} internally; and }
\item{When \code{offspring.type = "P"},}{ we set parameters \code{disp = +Inf} and \code{shift = mean} internally. }
}
}
\note{
It would be difficult to interpret the converted statistical parameters,
and thus we set this function \code{convert.epipara.to.delappara()} as a internal function.
We do not recommend the users to use this function externally unless for special reasons.
}
\examples{
convert.epipara.to.delappara(
  para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = 'D'
)
convert.epipara.to.delappara(
  para = list(mean = 1, disp = 1, shift = 0),
  offspring.type = 'G'
)

convert.epipara.to.delappara(
  para = list(mean = c(0.5, 1, 2), disp = c(0.1, 0.1, 0.3), shift = 0.2)
)

}
\references{
Vose D. Risk analysis: a quantitative guide. John Wiley & Sons. 2008; pp. 618-619. ISBN: 978-0-470-51284-5
}
\seealso{
\code{\link[Delaporte:ddelap]{Delaporte}} for the parameterization of Delaporte distribution.
}
\keyword{internal}
