% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelStudio.R
\name{modelStudio}
\alias{modelStudio}
\alias{modelStudio.explainer}
\alias{modelStudio.default}
\title{Generates interactive studio to explain predictive model}
\usage{
modelStudio(object, ...)

\method{modelStudio}{explainer}(object, new_observation, facet_dim = c(2,
  2), time = 500, max_features = 10, N = 500, B = 25,
  show_info = TRUE, parallel = FALSE, options = modelStudioOptions(),
  viewer = "external", ...)

\method{modelStudio}{default}(object, data, y,
  predict_function = predict, label = class(model)[1], new_observation,
  facet_dim = c(2, 2), time = 500, max_features = 10, N = 500,
  B = 25, show_info = TRUE, parallel = FALSE,
  options = modelStudioOptions(), viewer = "external", ...)
}
\arguments{
\item{object}{an explainer created with function \code{DALEX::explain()} or a model to be explained.}

\item{...}{other parameters.}

\item{new_observation}{a new observation with columns that correspond to variables used in the model.}

\item{facet_dim}{dimensions of the grid. Default is \code{c(2,2)}.}

\item{time}{in ms. Set animation length. Default is \code{500}.}

\item{max_features}{maximum number of features to be included in Break Down and Shapley Values plot. Default is \code{10}.}

\item{N}{number of observations used for calculation of partial dependency profiles. Default is \code{500}.}

\item{B}{number of random paths used for calculation of shapley values. Default is \code{25}.}

\item{show_info}{verbose progress bar on console? Default is \code{TRUE}.}

\item{parallel}{speed up computation using \code{parallelMap::parallelMap()}.
See \href{https://modeloriented.github.io/modelStudio/articles/vignette_modelStudio.html#parallel-computation}{\bold{vignette}}.}

\item{options}{customize \code{modelStudio}. See \code{\link{modelStudioOptions}} and
\href{https://modeloriented.github.io/modelStudio/articles/vignette_modelStudio.html#plot-options}{\bold{vignette}}.}

\item{viewer}{Default is \code{external} to display in an external RStudio window.
Use \code{browser} to display in an external browser or
\code{internal} to use the RStudio internal viewer pane for output.}

\item{data}{validation dataset, will be extracted from \code{object} if it is an explainer.
NOTE: It is best when target variable is not present in the \code{data}.}

\item{y}{true labels for \code{data}, will be extracted from \code{object} if it is an explainer.}

\item{predict_function}{predict function, will be extracted from \code{object} if it is an explainer.}

\item{label}{a name of the model, will be extracted from \code{object} if it is an explainer.}
}
\value{
an object of the \code{r2d3} class
}
\description{
This tool uses your model, data and new observations, to provide local
and global explanations. It generates plots and descriptions in the form
of the serverless HTML site, that supports animations and interactivity made with D3.js.
}
\examples{
library("modelStudio")

# ex1 classification

titanic_small <- DALEX::titanic_imputed[,c(1,2,3,6,7,9)]
titanic_small$survived <- titanic_small$survived == "yes"

model_titanic_glm <- glm(survived ~ gender + age + fare + class + sibsp,
                         data = titanic_small, family = "binomial")

explain_titanic_glm <- DALEX::explain(model_titanic_glm,
                                      data = titanic_small[,-6],
                                      y = titanic_small[,6],
                                      label = "glm",
                                      verbose = FALSE)

new_observations <- titanic_small[1:2,]
rownames(new_observations) <- c("Lucas","James")

modelStudio(explain_titanic_glm, new_observations,
            N = 100, B = 10, show_info = FALSE)

\donttest{
# ex2 regression

apartments <- DALEX::apartments

model_apartments <- glm(m2.price ~. ,
                        data = apartments)

explain_apartments <- DALEX::explain(model_apartments,
                                     data = apartments[,-1],
                                     y = apartments[,1],
                                     verbose = FALSE)

new_apartments <- apartments[1:2,]
rownames(new_apartments) <- c("ap1","ap2")

modelStudio(explain_apartments, new_apartments,
            facet_dim = c(1,2), time = 1000,
            show_info = FALSE)
}

}
\references{
\href{https://modeloriented.github.io/ingredients/}{\bold{ingredients}}
\href{https://modeloriented.github.io/iBreakDown/}{\bold{iBreakDown}}
\href{https://modeloriented.github.io/DALEX/}{\bold{DALEX}}
\href{https://modeloriented.github.io/DALEXtra/}{\bold{DALEXtra}}
}
