skip_on_cran()
skip_if_offline()
skip_if_not_installed("curl")
skip_if_not_installed("brms")
skip_if_not_installed("BH")
skip_if_not_installed("RcppEigen")
skip_if_not_installed("marginaleffects")
skip_if_not_installed("httr2")
skip_if_not_installed("MASS")

test_that("estimate_relation prints ordinal models correctly", {
  m <- insight::download_model("brms_categorical_2_num")
  out <- estimate_relation(m)
  expect_snapshot(print(out, zap_small = TRUE))
  out <- estimate_means(m, by = "Sepal.Width")
  expect_snapshot(print(out, zap_small = TRUE))

  m <- MASS::polr(Species ~ Sepal.Width, data = iris)
  out <- estimate_relation(m)
  expect_snapshot(print(out, zap_small = TRUE))
  out <- estimate_means(m, by = "Sepal.Width")
  expect_snapshot(print(out, zap_small = TRUE))
})
