% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataLoaders.R
\name{DataSet.CSV}
\alias{DataSet.CSV}
\title{R6 class representing a LaF csv data loader}
\description{
R6 class representing a LaF csv data loader

R6 class representing a LaF csv data loader
}
\details{
It uses the capability of the LaF package to load
sequentially batch of data from a csv file.
}
\author{
Filippo Monari
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{df}}{stores the batch of data read from the csv file}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DataSet.CSV$new()}}
\item \href{#method-..connect..}{\code{DataSet.CSV$..connect..()}}
\item \href{#method-..get.data..}{\code{DataSet.CSV$..get.data..()}}
\item \href{#method-feed}{\code{DataSet.CSV$feed()}}
\item \href{#method-dm}{\code{DataSet.CSV$dm()}}
\item \href{#method-clone}{\code{DataSet.CSV$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialisation method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.CSV$new(inf, n, yi, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inf}}{path to file or a LaF csv data model.}

\item{\code{n}}{number of rows to read ecah time from the csv file}

\item{\code{yi}}{indexes of the output variables}

\item{\code{...}}{additional arguments for the
\code{LaF::detect_dm_csv} function}

\item{\code{si}}{index of slicing dimension after feature engineering}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-..connect.."></a>}}
\if{latex}{\out{\hypertarget{method-..connect..}{}}}
\subsection{Method \code{..connect..()}}{
Opens the connection with the csv file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.CSV$..connect..(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{additional arguments for the
\code{LaF::laf_open} function}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-..get.data.."></a>}}
\if{latex}{\out{\hypertarget{method-..get.data..}{}}}
\subsection{Method \code{..get.data..()}}{
Return a batch of data of the wanted size.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.CSV$..get.data..()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{size of the batch of data}

\item{\code{...}}{additional arguments for the process fucntion}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-feed"></a>}}
\if{latex}{\out{\hypertarget{method-feed}{}}}
\subsection{Method \code{feed()}}{
Feed a number with the data from the CSV file
Returns X invisibly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.CSV$feed(data = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{list composed by X (containing the features) and Y (containing the targets).
If NULL a the list is created. If provided the numbers in ti will be fed in place.}

\item{\code{...}}{additional arguemnts to be passed to}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dm"></a>}}
\if{latex}{\out{\hypertarget{method-dm}{}}}
\subsection{Method \code{dm()}}{
Returns the data model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.CSV$dm()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.CSV$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
