% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers.R
\name{tidy.mira}
\alias{tidy.mira}
\title{Tidy a multiple imputation `mice` pooled object}
\usage{
\method{tidy}{mira}(x, ...)
}
\arguments{
\item{x}{An object returned by one of the `mice::pool` function.}

\item{...}{extra arguments (not used)}
}
\value{
a tibble with one row per term
}
\description{
Tidy a multiple imputation `mice` pooled object
}
\note{
Available stats in mipo object:
\itemize{
     \item estimate
     \item ubar
     \item b
     \item t
     \item dfcom
     \item df
     \item riv
     \item lambda
     \item fmi
}
}
\examples{
library(mice)
data <- airquality
data[4:10,3] <- rep(NA,7)
data[1:5,4] <- NA
tmp <- mice(data,m=5, seed=500, printFlag = FALSE)
mod <- with(tmp, lm(Temp~ Ozone+Solar.R+Wind))
tidy(mod)

}
\seealso{
Other tidiers: \code{\link{glance.mira}}
}
\concept{tidiers}
