% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers.R
\name{glance.mira}
\alias{glance.mira}
\title{Glance a multiple imputation `mice` pooled object}
\usage{
\method{glance}{mira}(x, ...)
}
\arguments{
\item{x}{An object with multiply-imputed models from `mice` (class: `mira`)}

\item{...}{extra arguments (not used)}
}
\value{
a tibble with one row
}
\description{
Glance a multiple imputation `mice` pooled object
}
\note{
If x contains `lm` models, R2 is included in the output
}
\examples{
library(mice)
data <- airquality
data[4:10,3] <- rep(NA,7)
data[1:5,4] <- NA
tmp <- mice(data,m=5, seed=500, printFlag = FALSE)
mod <- with(tmp, lm(Ozone ~ Solar.R + Wind))
glance(mod)

}
\concept{tidiers}
\keyword{internal}
